/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.num_translator.translator;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import kz.greetgo.num_translator.languages.Language;
import kz.greetgo.num_translator.mappers.ThreeDigitsBlock;

public class NumTranslator {
    Language language;

    public NumTranslator(Language lang) {
        this.language = lang;
    }

    public String translate(long number) {
        if (number == 0L) {
            return new ThreeDigitsBlock(0, this.language, 0).toWords();
        }
        String[] numberBlocks = this.splitByThreeDigits(number);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < numberBlocks.length; ++i) {
            int threeDigits = Integer.parseInt(numberBlocks[i]);
            if (threeDigits <= 0) continue;
            ThreeDigitsBlock block = new ThreeDigitsBlock(threeDigits, this.language, numberBlocks.length - i - 1);
            result.add(block.toWords());
        }
        return String.join((CharSequence)" ", result);
    }

    private String[] splitByThreeDigits(long number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number).replace(",", " ").split(" ");
    }
}

