/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.num_translator.mappers;

import java.util.HashMap;
import kz.greetgo.num_translator.languages.Language;
import kz.greetgo.num_translator.mappers.IBlockMapper;
import kz.greetgo.num_translator.mappers.ThreeDigitsBlock;

public class EngBlockMapper
implements IBlockMapper {
    private static final HashMap<Integer, String> unitToWordsEng = new HashMap<Integer, String>(){
        {
            this.put(0, "zero");
            this.put(1, "one");
            this.put(2, "two");
            this.put(3, "three");
            this.put(4, "four");
            this.put(5, "five");
            this.put(6, "six");
            this.put(7, "seven");
            this.put(8, "eight");
            this.put(9, "nine");
        }
    };
    private static final HashMap<Integer, String> decimalsInWordsEng = new HashMap<Integer, String>(){
        {
            this.put(1, "ten");
            this.put(2, "twenty");
            this.put(3, "thirty");
            this.put(4, "forty");
            this.put(5, "fifty");
            this.put(6, "sixty");
            this.put(7, "seventy");
            this.put(8, "eighty");
            this.put(9, "ninety");
        }
    };
    private static final HashMap<Integer, String> decimalsInWordsForTens = new HashMap<Integer, String>(){
        {
            this.put(1, "eleven");
            this.put(2, "twelve");
            this.put(3, "thirteen");
            this.put(4, "fourteen");
            this.put(5, "fifteen");
            this.put(6, "sixteen");
            this.put(7, "seventeen");
            this.put(8, "eighteen");
            this.put(9, "nineteen");
        }
    };
    private static final HashMap<Language, String> hundredBlockNameMapper = new HashMap<Language, String>(){
        {
            this.put(Language.ENG, " hundred");
        }
    };

    @Override
    public String unitToWordsMapper(ThreeDigitsBlock num) {
        if (num.getDecimals() == 1) {
            return " ";
        }
        return unitToWordsEng.get(num.getUnits());
    }

    @Override
    public String decimalToWordsMapper(ThreeDigitsBlock num) {
        if (num.getNumber() % 100 >= 11 && num.getNumber() % 100 <= 19) {
            return decimalsInWordsForTens.get(num.getUnits());
        }
        return decimalsInWordsEng.get(num.getDecimals());
    }

    @Override
    public String hundredToWordsMapper(ThreeDigitsBlock num) {
        return unitToWordsEng.get(num.getHundreds()) + hundredBlockNameMapper.get((Object)num.getLanguage());
    }
}

