/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.num_translator.mappers;

import java.util.HashMap;
import kz.greetgo.num_translator.languages.Language;

public class BlockPosition {
    static final HashMap<Integer, String> thousandsDegreesKaz = new HashMap<Integer, String>(){
        {
            this.put(0, "");
            this.put(1, "\u043c\u044b\u04a3");
            this.put(2, "\u043c\u0438\u043b\u043b\u0438\u043e\u043d");
            this.put(3, "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434");
            this.put(4, "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d");
        }
    };
    static final HashMap<Integer, String> thousandsDegreesQaz = new HashMap<Integer, String>(){
        {
            this.put(0, "");
            this.put(1, "my\u0144");
            this.put(2, "m\u0131ll\u0131on");
            this.put(3, "m\u0131ll\u0131ard");
            this.put(4, "tr\u0131ll\u0131on");
        }
    };
    static final HashMap<Integer, String> thousandsDegreesEng = new HashMap<Integer, String>(){
        {
            this.put(0, "");
            this.put(1, "thousand");
            this.put(2, "million");
            this.put(3, "billion");
            this.put(4, "trillion");
        }
    };
    static final HashMap<Integer, String[]> thousandsDegreesRus = new HashMap<Integer, String[]>(){
        {
            this.put(0, new String[]{""});
            this.put(1, new String[]{"\u0442\u044b\u0441\u044f\u0447\u0430", "\u0442\u044b\u0441\u044f\u0447\u0438", "\u0442\u044b\u0441\u044f\u0447"});
            this.put(2, new String[]{"\u043c\u0438\u043b\u043b\u0438\u043e\u043d", "\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u0430", "\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432"});
            this.put(3, new String[]{"\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434", "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u0430", "\u043c\u0438\u043b\u043b\u0438\u0430\u0440\u0434\u043e\u0432"});
            this.put(4, new String[]{"\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d", "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u0430", "\u0442\u0440\u0438\u043b\u043b\u0438\u043e\u043d\u043e\u0432"});
        }
    };
    int posNumber;
    int threeDigits;
    Language language;

    public BlockPosition(int posNumber, Language language, int threeDigits) {
        this.posNumber = posNumber;
        this.language = language;
        this.threeDigits = threeDigits;
    }

    public int getBlockPosition() {
        return this.posNumber;
    }

    public String getBlockName() {
        switch (this.language) {
            case KAZ: {
                return thousandsDegreesKaz.get(this.posNumber);
            }
            case QAZ: {
                return thousandsDegreesQaz.get(this.posNumber);
            }
            case ENG: {
                return thousandsDegreesEng.get(this.posNumber);
            }
        }
        int lastTwoDigit = this.threeDigits % 100;
        int lastDigit = this.threeDigits % 10;
        if (lastDigit == 1 && lastTwoDigit != 11 || this.posNumber == 0) {
            return thousandsDegreesRus.get(this.posNumber)[0];
        }
        if (lastDigit >= 2 && lastDigit <= 4 && lastTwoDigit / 10 != 1) {
            return thousandsDegreesRus.get(this.posNumber)[1];
        }
        return thousandsDegreesRus.get(this.posNumber)[2];
    }
}

