/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.num_translator.mappers;

import java.util.HashMap;
import kz.greetgo.num_translator.languages.Language;
import kz.greetgo.num_translator.mappers.IBlockMapper;
import kz.greetgo.num_translator.mappers.ThreeDigitsBlock;

public class RusBlockMapper
implements IBlockMapper {
    private static final HashMap<Integer, String[]> unitToWordsRus = new HashMap<Integer, String[]>(){
        {
            this.put(0, new String[]{"\u043d\u043e\u043b\u044c"});
            this.put(1, new String[]{"\u043e\u0434\u0438\u043d", "\u043e\u0434\u043d\u0430"});
            this.put(2, new String[]{"\u0434\u0432\u0430", "\u0434\u0432\u0435"});
            this.put(3, new String[]{"\u0442\u0440\u0438"});
            this.put(4, new String[]{"\u0447\u0435\u0442\u044b\u0440\u0435"});
            this.put(5, new String[]{"\u043f\u044f\u0442\u044c"});
            this.put(6, new String[]{"\u0448\u0435\u0441\u0442\u044c"});
            this.put(7, new String[]{"\u0441\u0435\u043c\u044c"});
            this.put(8, new String[]{"\u0432\u043e\u0441\u0435\u043c\u044c"});
            this.put(9, new String[]{"\u0434\u0435\u0432\u044f\u0442\u044c"});
        }
    };
    private static final HashMap<Integer, String> decimalsInWordsRus = new HashMap<Integer, String>(){
        {
            this.put(1, "\u0434\u0435\u0441\u044f\u0442\u044c");
            this.put(2, "\u0434\u0432\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(3, "\u0442\u0440\u0438\u0434\u0446\u0430\u0442\u044c");
            this.put(4, "\u0441\u043e\u0440\u043e\u043a");
            this.put(5, "\u043f\u044f\u0442\u044c\u0434\u0435\u0441\u044f\u0442");
            this.put(6, "\u0448\u0435\u0441\u0442\u044c\u0434\u0435\u0441\u044f\u0442");
            this.put(7, "\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442");
            this.put(8, "\u0432\u043e\u0441\u0435\u043c\u044c\u0434\u0435\u0441\u044f\u0442");
            this.put(9, "\u0434\u0435\u0432\u044f\u043d\u043e\u0441\u0442\u043e");
        }
    };
    private static final HashMap<Integer, String> decimalsInWordsRusForTens = new HashMap<Integer, String>(){
        {
            this.put(1, "\u043e\u0434\u0438\u043d\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(2, "\u0434\u0432\u0435\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(3, "\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(4, "\u0447\u0435\u0442\u044b\u0440\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(5, "\u043f\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(6, "\u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(7, "\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(8, "\u0432\u043e\u0441\u0435\u043c\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
            this.put(9, "\u0434\u0435\u0432\u044f\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u044c");
        }
    };
    private static final String[] hundredBlockNameMapperRus = new String[]{"", "\u0441\u0442\u043e", "\u0434\u0432\u0435\u0441\u0442\u0438", "\u0442\u0440\u0438\u0441\u0442\u0430", "\u0447\u0435\u0442\u044b\u0440\u0435\u0441\u0442\u0430", "\u043f\u044f\u0442\u044c\u0441\u043e\u0442", "\u0448\u0435\u0441\u0442\u044c\u0441\u043e\u0442", "\u0441\u0435\u043c\u044c\u0441\u043e\u0442", "\u0432\u043e\u0441\u0435\u043c\u044c\u0441\u043e\u0442", "\u0434\u0435\u0432\u044f\u0442\u044c\u0441\u043e\u0442"};
    private static final HashMap<Language, String[]> floatingPointWordRus = new HashMap<Language, String[]>(){
        {
            this.put(Language.RUS, new String[]{"\u0446\u0435\u043b\u044b\u0445", "\u0446\u0435\u043b\u0430\u044f"});
        }
    };
    private static final HashMap<Integer, String[]> floatingPartWordsRus = new HashMap<Integer, String[]>(){
        {
            this.put(1, new String[]{"\u0434\u0435\u0441\u044f\u0442\u044b\u0445", "\u0434\u0435\u0441\u044f\u0442\u0430\u044f"});
            this.put(2, new String[]{"\u0441\u043e\u0442\u044b\u0445", "\u0441\u043e\u0442\u0430\u044f"});
            this.put(3, new String[]{"\u0442\u044b\u0441\u044f\u0447\u043d\u044b\u0445", "\u0442\u044b\u0441\u044f\u0447\u043d\u0430\u044f"});
        }
    };

    @Override
    public String unitToWordsMapper(ThreeDigitsBlock num) {
        if (num.isDouble && num.getBlockPosition() == 0 && num.getDecimals() != 1 && (num.getUnits() == 1 || num.getUnits() == 2)) {
            return unitToWordsRus.get(num.getUnits())[1];
        }
        if (num.getDecimals() == 1) {
            return " ";
        }
        if (num.getBlockPosition() == 1 && (num.getUnits() == 1 || num.getUnits() == 2)) {
            return unitToWordsRus.get(num.getUnits())[1];
        }
        return unitToWordsRus.get(num.getUnits())[0];
    }

    @Override
    public String decimalToWordsMapper(ThreeDigitsBlock num) {
        if (num.getNumber() % 100 >= 11 && num.getNumber() % 100 <= 19) {
            return decimalsInWordsRusForTens.get(num.getUnits());
        }
        return decimalsInWordsRus.get(num.getDecimals());
    }

    @Override
    public String hundredToWordsMapper(ThreeDigitsBlock num) {
        return hundredBlockNameMapperRus[num.getHundreds()];
    }

    @Override
    public String floatingPointToWordMapper(ThreeDigitsBlock num) {
        if (num.getDecimals() != 1 && num.getUnits() == 1) {
            return floatingPointWordRus.get((Object)Language.RUS)[1];
        }
        return floatingPointWordRus.get((Object)Language.RUS)[0];
    }

    @Override
    public String floatingPartToWordsMapper(ThreeDigitsBlock num, int numLength) {
        if (num.getDecimals() != 1 && num.getUnits() == 1) {
            return floatingPartWordsRus.get(numLength)[1];
        }
        return floatingPartWordsRus.get(numLength)[0];
    }
}

