/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.num_translator.mappers;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import kz.greetgo.num_translator.languages.Language;
import kz.greetgo.num_translator.mappers.BlockPosition;
import kz.greetgo.num_translator.mappers.EngBlockMapper;
import kz.greetgo.num_translator.mappers.IBlockMapper;
import kz.greetgo.num_translator.mappers.KazBlockMapper;
import kz.greetgo.num_translator.mappers.QazBlockMapper;
import kz.greetgo.num_translator.mappers.RusBlockMapper;

public class ThreeDigitsBlock {
    IBlockMapper mapper;
    BlockPosition blockPosition;
    Language language;
    boolean isDouble;
    int hundreds;
    int decimals;
    int units;

    public ThreeDigitsBlock(int number, Language language, int position, boolean isDouble) {
        this.hundreds = Math.max(number / 100, 0);
        this.decimals = Math.max(number / 10 % 10, 0);
        this.units = Math.max(number % 10, 0);
        this.language = language;
        this.blockPosition = new BlockPosition(position, language, number);
        this.isDouble = isDouble;
        this.mapper = language.toString().equalsIgnoreCase("kaz") ? new KazBlockMapper() : (language.toString().equalsIgnoreCase("eng") ? new EngBlockMapper() : (language.toString().equalsIgnoreCase("qaz") ? new QazBlockMapper() : new RusBlockMapper()));
    }

    public int getNumber() {
        return this.hundreds * 100 + this.decimals * 10 + this.units;
    }

    public int getHundreds() {
        return this.hundreds;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int getUnits() {
        return this.units;
    }

    public int getBlockPosition() {
        return this.blockPosition.getBlockPosition();
    }

    public String getHundredsInWords() {
        return this.hundreds > 0 ? this.mapper.hundredToWordsMapper(this) : "";
    }

    public String getDecimalInWords() {
        return this.decimals > 0 ? this.mapper.decimalToWordsMapper(this) : "";
    }

    public String getUnitInWords() {
        return this.units > 0 || this.getNumber() < 10 ? this.mapper.unitToWordsMapper(this) : "";
    }

    public String getFloatingPointInWord() {
        return this.mapper.floatingPointToWordMapper(this);
    }

    public String getFloatingPartToWordsMapper(int numLength) {
        return this.mapper.floatingPartToWordsMapper(this, numLength);
    }

    public Language getLanguage() {
        return this.language;
    }

    public String toWords() {
        return Stream.of(this.getHundredsInWords(), this.getDecimalInWords(), this.getUnitInWords(), this.blockPosition.getBlockName()).filter(str -> !str.isBlank()).collect(Collectors.joining(" "));
    }
}

