/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.num_translator.translator;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import kz.greetgo.num_translator.languages.Language;
import kz.greetgo.num_translator.mappers.ThreeDigitsBlock;

public class NumTranslator {
    Language language;
    private boolean isDouble;

    public NumTranslator(Language lang) {
        this.language = lang;
    }

    public String translate(BigDecimal number) {
        if (number.compareTo(new BigDecimal(number.longValue())) == 0) {
            return new NumTranslator(this.language).translateFromLong(number.longValue());
        }
        return new NumTranslator(this.language).translateFromDouble(number.doubleValue());
    }

    private String translateFromLong(long number) {
        if (number == 0L) {
            return new ThreeDigitsBlock(0, this.language, 0, false).toWords();
        }
        String[] numberBlocks = this.splitByThreeDigits(number);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < numberBlocks.length; ++i) {
            int threeDigits = Integer.parseInt(numberBlocks[i]);
            if (threeDigits <= 0) continue;
            ThreeDigitsBlock block = new ThreeDigitsBlock(threeDigits, this.language, numberBlocks.length - i - 1, this.isDouble);
            result.add(block.toWords());
        }
        return String.join((CharSequence)" ", result);
    }

    private String translateFromDouble(Double number) {
        this.isDouble = true;
        boolean isZero = false;
        if (number == 0.0) {
            return new ThreeDigitsBlock(0, this.language, 0, this.isDouble).toWords();
        }
        number = this.round(number, 3);
        String[] wholeAndDecimalParts = this.splitDoubleToWholeAndDecimal(number);
        ArrayList<String> result = new ArrayList<String>();
        if (wholeAndDecimalParts[wholeAndDecimalParts.length - 1].equals("0")) {
            result.add(this.translateFromLong(number.longValue()));
            isZero = true;
        }
        if (!isZero) {
            String part = "";
            part = wholeAndDecimalParts[0];
            if (!this.language.equals((Object)Language.ENG) || !part.equals("0")) {
                result.add(this.translateFromLong(Long.parseLong(part)));
                if (part.length() >= 3) {
                    result.add(new ThreeDigitsBlock(Integer.parseInt(part.substring(part.length() - 3)), this.language, 0, this.isDouble).getFloatingPointInWord());
                } else {
                    result.add(new ThreeDigitsBlock(Integer.parseInt(part), this.language, 0, this.isDouble).getFloatingPointInWord());
                }
            }
            part = wholeAndDecimalParts[1];
            if (this.language.equals((Object)Language.KAZ) || this.language.equals((Object)Language.QAZ)) {
                result.add(this.getFloatingPart(part));
            }
            result.add(this.translateFromLong(Long.parseLong(part)));
            if (this.language.equals((Object)Language.ENG) || this.language.equals((Object)Language.RUS)) {
                result.add(this.getFloatingPart(part));
            }
        }
        return String.join((CharSequence)" ", result);
    }

    private String getFloatingPart(String part) {
        return new ThreeDigitsBlock(Integer.parseInt(part), this.language, 0, this.isDouble).getFloatingPartToWordsMapper(part.length());
    }

    private String[] splitByThreeDigits(long number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number).replace(",", " ").split(" ");
    }

    private String[] splitDoubleToWholeAndDecimal(double number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number).replace(",", "").split("\\.");
    }

    private double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }
}

