/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto;

import com.mongodb.client.MongoCollection;
import java.io.File;
import java.util.Objects;
import kz.greetgo.db.DbType;
import kz.greetgo.db.Jdbc;
import kz.greetgo.security.crypto.ContentAccess;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.crypto.CryptoBridge;
import kz.greetgo.security.crypto.CryptoBuilderKeysInDb;
import kz.greetgo.security.crypto.CryptoBuilderKeysInFiles;
import kz.greetgo.security.crypto.CryptoBuilderKeysInMongo;
import kz.greetgo.security.crypto.CryptoSourceConfig;
import kz.greetgo.security.crypto.CryptoSourceConfigDefault;
import kz.greetgo.security.crypto.CryptoSourceImpl;
import org.bson.Document;

public class CryptoBuilder {
    CryptoSourceConfig cryptoSourceConfig = new CryptoSourceConfigDefault();
    int keySize = 1024;

    CryptoBuilder() {
    }

    public static CryptoBuilder newBuilder() {
        return new CryptoBuilder();
    }

    public CryptoBuilder setKeySize(int keySize) {
        this.keySize = keySize;
        return this;
    }

    public CryptoBuilderKeysInFiles inFiles(File privateKeyFile, File publicKeyFile) {
        return new CryptoBuilderKeysInFiles(this, privateKeyFile, publicKeyFile);
    }

    public CryptoBuilder setConfig(CryptoSourceConfig cryptoSourceConfig) {
        this.cryptoSourceConfig = cryptoSourceConfig;
        return this;
    }

    public Crypto build(ContentAccess privateKeyAccess, ContentAccess publicKeyAccess) {
        Objects.requireNonNull(privateKeyAccess);
        Objects.requireNonNull(publicKeyAccess);
        return new CryptoBridge(new CryptoSourceImpl(this.cryptoSourceConfig, privateKeyAccess, publicKeyAccess, this.keySize));
    }

    public CryptoBuilderKeysInDb inDb(DbType dbType, Jdbc jdbc) {
        Objects.requireNonNull(dbType);
        Objects.requireNonNull(jdbc);
        return new CryptoBuilderKeysInDb(this, dbType, jdbc);
    }

    public CryptoBuilderKeysInMongo inMongo(MongoCollection<Document> collection) {
        return this.inMongo(collection, collection);
    }

    public CryptoBuilderKeysInMongo inMongo(MongoCollection<Document> privateKey, MongoCollection<Document> publicKey) {
        Objects.requireNonNull(privateKey);
        Objects.requireNonNull(publicKey);
        return new CryptoBuilderKeysInMongo(this, privateKey, publicKey);
    }
}

