/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.session.SaltGenerator;
import kz.greetgo.security.session.SaltGeneratorCryptoBridge;
import kz.greetgo.security.session.SessionLog;
import kz.greetgo.security.session.SessionService;
import kz.greetgo.security.session.SessionServiceImpl;
import kz.greetgo.security.session.SessionStorage;
import kz.greetgo.security.session.SessionValidator;

public class SessionServiceBuilder {
    SessionStorage storage;
    SaltGenerator saltGenerator;
    int oldSessionAgeInHours = 24;
    int sessionIdLength = 15;
    int tokenLength = 15;
    LongSupplier lastTouchedCacheTimeoutSec = () -> 30L;
    IntSupplier lastTouchedCacheSize = () -> 1000000;
    LongSupplier validateSessionDelayMillis = () -> 10000L;
    SessionValidator<Object> sessionValidator = null;
    SessionLog sessionLog = Throwable::printStackTrace;
    private boolean built = false;

    private SessionServiceBuilder() {
    }

    public static SessionServiceBuilder newBuilder() {
        return new SessionServiceBuilder();
    }

    public <T> SessionServiceBuilder sessionValidator(SessionValidator<T> sessionValidator) {
        this.checkBuilt();
        this.sessionValidator = sessionValidator;
        return this;
    }

    public SessionServiceBuilder sessionLog(SessionLog sessionLog) {
        this.checkBuilt();
        this.sessionLog = Objects.requireNonNull(sessionLog, "CMNjR6SkFq :: sessionLog");
        return this;
    }

    public SessionServiceBuilder setValidateSessionDelayMillis(LongSupplier validateSessionDelayMillis) {
        this.checkBuilt();
        this.validateSessionDelayMillis = Objects.requireNonNull(validateSessionDelayMillis, "mj2y4oz57T :: validateSessionDelayMillis");
        return this;
    }

    public SessionServiceBuilder setStorage(SessionStorage storage) {
        this.checkBuilt();
        this.storage = storage;
        return this;
    }

    private void checkBuilt() {
        if (this.built) {
            throw new RuntimeException("00vy8Th268 :: Already built");
        }
    }

    public SessionServiceBuilder setSaltGenerator(SaltGenerator saltGenerator) {
        this.checkBuilt();
        this.saltGenerator = saltGenerator;
        return this;
    }

    public SessionServiceBuilder setSaltGeneratorOnCrypto(Crypto crypto, int saltLength, byte[] saltMixture) {
        this.checkBuilt();
        this.saltGenerator = new SaltGeneratorCryptoBridge(crypto, saltLength, saltMixture);
        return this;
    }

    public SessionServiceBuilder setOldSessionAgeInHours(int oldSessionAgeInHours) {
        this.checkBuilt();
        this.oldSessionAgeInHours = oldSessionAgeInHours;
        return this;
    }

    public SessionServiceBuilder setSessionIdLength(int sessionIdLength) {
        this.checkBuilt();
        this.sessionIdLength = sessionIdLength;
        return this;
    }

    public SessionServiceBuilder setTokenLength(int tokenLength) {
        this.checkBuilt();
        this.tokenLength = tokenLength;
        return this;
    }

    public SessionServiceBuilder setLastTouchedCacheTimeoutSec(LongSupplier lastTouchedCacheTimeoutSec) {
        this.checkBuilt();
        this.lastTouchedCacheTimeoutSec = Objects.requireNonNull(lastTouchedCacheTimeoutSec);
        return this;
    }

    public SessionServiceBuilder setLastTouchedCacheTimeoutSec(long dbCacheTimeoutSec) {
        this.checkBuilt();
        return this.setLastTouchedCacheTimeoutSec(() -> dbCacheTimeoutSec);
    }

    public SessionServiceBuilder setLastTouchedCacheSize(IntSupplier lastTouchedCacheSize) {
        this.checkBuilt();
        this.lastTouchedCacheSize = Objects.requireNonNull(lastTouchedCacheSize);
        return this;
    }

    public SessionServiceBuilder setLastTouchedCacheSize(int lastTouchedCacheSize) {
        this.checkBuilt();
        return this.setLastTouchedCacheSize(() -> lastTouchedCacheSize);
    }

    public SessionService build() {
        this.built = true;
        if (this.storage == null) {
            throw new RuntimeException("lNUic2LKvg :: No sessionStorage");
        }
        if (this.saltGenerator == null) {
            throw new RuntimeException("h1tmyAyHG2 :: No saltGenerator");
        }
        return new SessionServiceImpl(this);
    }
}

