/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session.cache;

import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import kz.greetgo.security.session.cache.Cache;

public class CacheBuilder<Input extends Comparable<Input>, Output> {
    private LongSupplier refreshTimeoutSec;
    private IntSupplier maxSize;
    private Function<Input, Output> loader;
    private LongSupplier nowMillisSupplier = System::currentTimeMillis;

    public CacheBuilder<Input, Output> nowMillisSupplier(LongSupplier nowSupplier) {
        this.nowMillisSupplier = Objects.requireNonNull(nowSupplier);
        return this;
    }

    public CacheBuilder<Input, Output> nowDateSupplier(Supplier<Date> nowSupplier) {
        Objects.requireNonNull(nowSupplier);
        return this.nowMillisSupplier(() -> Objects.requireNonNull((Date)nowSupplier.get()).getTime());
    }

    public CacheBuilder<Input, Output> refreshTimeoutSec(LongSupplier refreshTimeoutSec) {
        this.refreshTimeoutSec = refreshTimeoutSec;
        return this;
    }

    public CacheBuilder<Input, Output> refreshTimeoutSec(long refreshTimeoutSec) {
        return this.refreshTimeoutSec(() -> refreshTimeoutSec);
    }

    public CacheBuilder<Input, Output> maxSize(IntSupplier maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public CacheBuilder<Input, Output> maxSize(int maxSize) {
        return this.maxSize(() -> maxSize);
    }

    public CacheBuilder<Input, Output> loader(Function<Input, Output> loader) {
        this.loader = loader;
        return this;
    }

    public Cache<Input, Output> build() {
        Objects.requireNonNull(this.refreshTimeoutSec);
        Objects.requireNonNull(this.maxSize);
        Objects.requireNonNull(this.loader);
        return new Cache<Input, Output>(this.refreshTimeoutSec, this.maxSize, this.loader, this.nowMillisSupplier);
    }
}

