/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.password;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;
import java.nio.charset.StandardCharsets;
import kz.greetgo.security.password.PasswordEncoder;

public class PasswordEncoderBuilder {
    private int iterations = 4;
    private int memory = 16384;
    private int parallelism = 10;
    private boolean built = false;

    PasswordEncoderBuilder() {
    }

    public static PasswordEncoderBuilder newBuilder() {
        return new PasswordEncoderBuilder();
    }

    private void checkBuilt() {
        if (this.built) {
            throw new RuntimeException("RJ7gBe1nxE :: Already built");
        }
    }

    public PasswordEncoderBuilder iterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public PasswordEncoderBuilder memory(int memory) {
        this.memory = memory;
        return this;
    }

    public PasswordEncoderBuilder parallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public PasswordEncoder build() {
        this.checkBuilt();
        final Argon2 argon2 = Argon2Factory.create((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2id);
        this.built = true;
        return new PasswordEncoder(){

            @Override
            public String encode(String password) {
                return argon2.hash(PasswordEncoderBuilder.this.iterations, PasswordEncoderBuilder.this.memory, PasswordEncoderBuilder.this.parallelism, PasswordEncoderBuilder.this.passwordToBytes(password));
            }

            @Override
            public boolean verify(String password, String encodedPassword) {
                return argon2.verify(encodedPassword, PasswordEncoderBuilder.this.passwordToBytes(password));
            }
        };
    }

    private byte[] passwordToBytes(String password) {
        if (password == null) {
            password = "";
        }
        return password.getBytes(StandardCharsets.UTF_8);
    }
}

