/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import kz.greetgo.security.crypto.ContentAccess;
import kz.greetgo.security.crypto.CryptoSource;
import kz.greetgo.security.crypto.CryptoSourceConfig;

public class CryptoSourceImpl
implements CryptoSource {
    private final ContentAccess privateKeyAccess;
    private final ContentAccess publicKeyAccess;
    private final int keySize;
    private final CryptoSourceConfig conf;
    private final ThreadLocal<PublicKey> publicKey = new ThreadLocal();
    private final ThreadLocal<PrivateKey> privateKey = new ThreadLocal();
    private final ThreadLocal<SecureRandom> random = new ThreadLocal();
    private final ThreadLocal<MessageDigest> messageDigest = new ThreadLocal();

    private boolean hasKeys() {
        return this.privateKeyAccess.exists() && this.publicKeyAccess.exists();
    }

    public CryptoSourceImpl(CryptoSourceConfig conf, ContentAccess privateKeyAccess, ContentAccess publicKeyAccess, int keySize) {
        this.conf = conf;
        this.privateKeyAccess = privateKeyAccess;
        this.publicKeyAccess = publicKeyAccess;
        this.keySize = keySize;
    }

    @Override
    public int getBlockSize() {
        return this.conf.blockSize();
    }

    @Override
    public Cipher getCipher() {
        try {
            return Cipher.getInstance(this.conf.cipherAlgorithm());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareKeys() {
        if (this.privateKey.get() != null || this.publicKey.get() != null) {
            return;
        }
        CryptoSourceImpl cryptoSourceImpl = this;
        synchronized (cryptoSourceImpl) {
            if (this.privateKey.get() != null || this.publicKey.get() != null) {
                return;
            }
            this.doPrepareKeys();
        }
    }

    @Override
    public PublicKey getPublicKey() {
        this.prepareKeys();
        return this.publicKey.get();
    }

    @Override
    public PrivateKey getPrivateKey() {
        this.prepareKeys();
        return this.privateKey.get();
    }

    @Override
    public SecureRandom getRandom() {
        SecureRandom secureRandom = this.random.get();
        if (secureRandom != null) {
            return secureRandom;
        }
        try {
            SecureRandom instance = SecureRandom.getInstance(this.conf.secureRandomAlgorithm());
            this.random.set(instance);
            return instance;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MessageDigest getMessageDigest() {
        MessageDigest result = this.messageDigest.get();
        if (result != null) {
            return result;
        }
        try {
            MessageDigest instance = MessageDigest.getInstance(this.conf.messageDigestAlgorithm());
            this.messageDigest.set(instance);
            return instance;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doPrepareKeys() {
        try {
            if (this.hasKeys()) {
                this.readKeysFromFiles();
                return;
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            // empty catch block
        }
        this.generateKeys();
        this.saveKeys();
    }

    protected void saveKeys() {
        PKCS8EncodedKeySpec privateKetSpec = new PKCS8EncodedKeySpec(this.privateKey.get().getEncoded());
        this.privateKeyAccess.uploadBytes(privateKetSpec.getEncoded());
        X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(this.publicKey.get().getEncoded());
        this.publicKeyAccess.uploadBytes(publicSpec.getEncoded());
    }

    protected void generateKeys() {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.conf.keyPairGeneratorAlgorithm());
            kpg.initialize(this.keySize, this.getRandom());
            KeyPair keyPair = kpg.generateKeyPair();
            this.privateKey.set(keyPair.getPrivate());
            this.publicKey.set(keyPair.getPublic());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected void readKeysFromFiles() throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpecPrivate = new PKCS8EncodedKeySpec(this.privateKeyAccess.downloadBytes());
        X509EncodedKeySpec keySpecPublic = new X509EncodedKeySpec(this.publicKeyAccess.downloadBytes());
        KeyFactory keyFactory = KeyFactory.getInstance(this.conf.keyFactoryAlgorithm());
        this.privateKey.set(keyFactory.generatePrivate(keySpecPrivate));
        this.publicKey.set(keyFactory.generatePublic(keySpecPublic));
    }
}

