/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.session.SaltGenerator;
import kz.greetgo.security.util.ByteUtil;
import org.bson.internal.Base64;

public class SaltGeneratorCryptoBridge
implements SaltGenerator {
    private final Crypto crypto;
    private final int rndLength;

    public SaltGeneratorCryptoBridge(Crypto crypto) {
        this(crypto, 32);
    }

    public SaltGeneratorCryptoBridge(Crypto crypto, int rndLength) {
        this.crypto = crypto;
        this.rndLength = rndLength;
    }

    @Override
    public String generateSalt(String str) {
        byte[] beginBytes = (str == null ? "" : str).getBytes(StandardCharsets.UTF_8);
        byte[] rndBytes = new byte[this.rndLength];
        this.crypto.rnd().nextBytes(rndBytes);
        byte[] sourceBytes = ByteUtil.xorBytes(rndBytes, ByteUtil.copyToLength(beginBytes, rndBytes.length));
        byte[] encryptedSourceBytes = this.crypto.encryptBlock(sourceBytes);
        byte[] resultBytes = new byte[rndBytes.length + encryptedSourceBytes.length];
        System.arraycopy(rndBytes, 0, resultBytes, 0, this.rndLength);
        System.arraycopy(encryptedSourceBytes, 0, resultBytes, this.rndLength, encryptedSourceBytes.length);
        String salt = Base64.encode((byte[])resultBytes);
        return salt.replace('/', '$').replace('+', '~').replace('=', '@');
    }

    @Override
    public boolean validateSalt(String str, String salt) {
        byte[] sourceBytes;
        byte[] resultBytes;
        if (salt == null) {
            return false;
        }
        String saltBase64 = salt.replace('$', '/').replace('~', '+').replace('@', '=');
        try {
            resultBytes = Base64.decode((String)saltBase64);
        }
        catch (Exception e) {
            return false;
        }
        if (resultBytes.length <= this.rndLength) {
            return false;
        }
        byte[] rndBytes = new byte[this.rndLength];
        byte[] encryptedSourceBytes = new byte[resultBytes.length - this.rndLength];
        System.arraycopy(resultBytes, 0, rndBytes, 0, this.rndLength);
        System.arraycopy(resultBytes, this.rndLength, encryptedSourceBytes, 0, encryptedSourceBytes.length);
        try {
            sourceBytes = this.crypto.decryptBlock(encryptedSourceBytes);
        }
        catch (Exception e) {
            return false;
        }
        byte[] beginBytes = (str == null ? "" : str).getBytes(StandardCharsets.UTF_8);
        byte[] sourceBytes2 = ByteUtil.xorBytes(rndBytes, ByteUtil.copyToLength(beginBytes, rndBytes.length));
        return Arrays.equals(sourceBytes, sourceBytes2);
    }
}

