/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session.touch;

import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import kz.greetgo.security.session.touch.TouchHandler;

public class PendingTouch
implements AutoCloseable {
    private final TouchHandler touchHandler;
    private final Supplier<Date> nowSupplier;
    private final LongSupplier delayMsSupplier;
    private final ConcurrentHashMap<String, Date2> pendingMap = new ConcurrentHashMap();

    public PendingTouch(Supplier<Date> nowSupplier, LongSupplier delayMsSupplier, TouchHandler touchHandler) {
        this.touchHandler = touchHandler;
        this.nowSupplier = nowSupplier;
        this.delayMsSupplier = delayMsSupplier;
    }

    public void touch(String sessionId) {
        this.pendingMap.computeIfAbsent((String)sessionId, (Function<String, Date2>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$touch$0(java.lang.String ), (Ljava/lang/String;)Lkz/greetgo/security/session/touch/PendingTouch$Date2;)((PendingTouch)this)).lastTouchedAt.set(this.nowSupplier.get());
    }

    public void idle() {
        Date border = new Date(this.nowSupplier.get().getTime() - this.delayMsSupplier.getAsLong());
        Map.Entry e;
        while ((e = (Map.Entry)this.pendingMap.entrySet().stream().filter(x -> border.after(((Date2)x.getValue()).firstTouchedAt)).findAny().orElse(null)) != null) {
            this.pendingMap.remove(e.getKey());
            this.touchHandler.updateLastModifiedAt((String)e.getKey(), ((Date2)e.getValue()).lastTouchedAt.get());
        }
        return;
    }

    @Override
    public void close() {
        Map.Entry e;
        while ((e = (Map.Entry)this.pendingMap.entrySet().stream().findAny().orElse(null)) != null) {
            this.pendingMap.remove(e.getKey());
            this.touchHandler.updateLastModifiedAt((String)e.getKey(), ((Date2)e.getValue()).lastTouchedAt.get());
        }
        return;
    }

    private /* synthetic */ Date2 lambda$touch$0(String id) {
        return new Date2(this.nowSupplier.get());
    }

    private static class Date2 {
        final Date firstTouchedAt;
        final AtomicReference<Date> lastTouchedAt;

        private Date2(Date touchedAt) {
            this.firstTouchedAt = touchedAt;
            this.lastTouchedAt = new AtomicReference<Date>(touchedAt);
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "Date2{" + sdf.format(this.firstTouchedAt) + " - " + sdf.format(this.lastTouchedAt.get()) + "}";
        }
    }
}

