/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.crypto.CryptoSource;
import kz.greetgo.security.crypto.CryptoTrace;

public class CryptoBridge
implements Crypto {
    public static CryptoTrace trace = null;
    private final CryptoSource cryptoSource;

    public CryptoBridge(CryptoSource cryptoSource) {
        this.cryptoSource = cryptoSource;
    }

    private static byte[] encryptBlock(byte[] bytes, CryptoSource cryptoSource) {
        try {
            Cipher cipher = cryptoSource.getCipher();
            cipher.init(1, cryptoSource.getPublicKey());
            return cipher.doFinal(bytes);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            if (trace != null) {
                trace.trace("CP 24WwTRF26U", e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] encryptBlock(byte[] bytes) {
        return CryptoBridge.encryptBlock(bytes, this.cryptoSource);
    }

    @Override
    public byte[] decryptBlock(byte[] encryptedBytes) {
        return CryptoBridge.decryptBlock(encryptedBytes, this.cryptoSource);
    }

    private static byte[] decryptBlock(byte[] encryptedBytes, CryptoSource cryptoSource) {
        try {
            Cipher cipher = cryptoSource.getCipher();
            cipher.init(2, cryptoSource.getPrivateKey());
            return cipher.doFinal(encryptedBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            if (trace != null) {
                trace.trace("CP A5dm6oys4i", e);
            }
            return null;
        }
        catch (InvalidKeyException e) {
            if (trace != null) {
                trace.trace("CP 5QATeDVTnj", e);
            }
            throw new RuntimeException(e);
        }
    }

    private static EncryptedData createEncryptedData(byte[] bytes, CryptoSource cryptoSource) {
        if (bytes == null) {
            return null;
        }
        EncryptedData ret = cryptoSource.getBlockSize() < bytes.length ? new ManyBlocks() : new SmallBlock();
        ret.encryptAndSet(bytes, cryptoSource);
        return ret;
    }

    static byte[] readFromBlockList(List<byte[]> blockList, byte[] symmetricKey) {
        int bytesCount = 0;
        for (byte[] block : blockList) {
            int blockLength = block.length;
            for (int j = 0; j < blockLength; ++j) {
                int n = j;
                block[n] = (byte)(block[n] ^ symmetricKey[j]);
            }
            bytesCount += blockLength;
        }
        byte[] ret = new byte[bytesCount];
        int filledCount = 0;
        for (byte[] block : blockList) {
            int blockLength = block.length;
            System.arraycopy(block, 0, ret, filledCount, blockLength);
            filledCount += blockLength;
        }
        return ret;
    }

    static void writeToBlockList(List<byte[]> blockList, byte[] symmetricKey, byte[] bytes) {
        int performedCount = 0;
        int bytesLength = bytes.length;
        int symmetricKeyLength = symmetricKey.length;
        while (performedCount < bytesLength) {
            int performBorder = performedCount + symmetricKeyLength;
            if (performBorder > bytesLength) {
                performBorder = bytesLength;
            }
            int currentBlockSize = performBorder - performedCount;
            byte[] block = new byte[currentBlockSize];
            System.arraycopy(bytes, performedCount, block, 0, currentBlockSize);
            for (int i = 0; i < currentBlockSize; ++i) {
                int n = i;
                block[n] = (byte)(block[n] ^ symmetricKey[i]);
            }
            blockList.add(block);
            performedCount = performBorder;
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        EncryptedData encryptedData = CryptoBridge.createEncryptedData(bytes, this.cryptoSource);
        if (encryptedData == null) {
            return null;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bOut);){
            oos.writeObject(encryptedData);
        }
        catch (IOException e) {
            if (trace != null) {
                trace.trace("CP tToHF5T7vr", e);
            }
            throw new RuntimeException(e);
        }
        return bOut.toByteArray();
    }

    @Override
    public byte[] decrypt(byte[] encryptedBytes) {
        byte[] byArray;
        if (encryptedBytes == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encryptedBytes);
        ObjectInputStream ois = new ObjectInputStream(bIn);
        try {
            EncryptedData encryptedData = (EncryptedData)ois.readObject();
            byArray = encryptedData.decryptAndGet(this.cryptoSource);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassCastException | ClassNotFoundException e) {
                if (trace != null) {
                    trace.trace("CP 6c37UGb42g", e);
                }
                return null;
            }
        }
        ois.close();
        return byArray;
    }

    @Override
    public byte[] sign(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            byte[] hash1 = this.cryptoSource.getMessageDigest().digest(bytes);
            Cipher cipher = this.cryptoSource.getCipher();
            cipher.init(1, this.cryptoSource.getPrivateKey());
            return cipher.doFinal(hash1);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            if (trace != null) {
                trace.trace("CP 7xTj50ch06", e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean verifySignature(byte[] bytes, byte[] signature) {
        if (signature == null || bytes == null) {
            if (trace != null) {
                trace.trace("CP I1iC54087r");
            }
            return false;
        }
        try {
            byte[] hash1 = this.cryptoSource.getMessageDigest().digest(bytes);
            Cipher cipher = this.cryptoSource.getCipher();
            cipher.init(2, this.cryptoSource.getPublicKey());
            byte[] hash2 = cipher.doFinal(signature);
            if (hash1.length != hash2.length) {
                if (trace != null) {
                    trace.trace("CP DR5Xd1NH19");
                }
                return false;
            }
            int n = hash1.length;
            for (int i = 0; i < n; ++i) {
                if (hash1[i] == hash2[i]) continue;
                if (trace != null) {
                    trace.trace("CP 7tJoTkWm0H");
                }
                return false;
            }
            if (trace != null) {
                trace.trace("CP m9t3OpQL0O");
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException | BadPaddingException | IllegalBlockSizeException e) {
            if (trace != null) {
                trace.trace("CP AJ1k7Gy2Hk", e);
            }
            return false;
        }
        catch (InvalidKeyException e) {
            if (trace != null) {
                trace.trace("CP 08saDm2rsb", e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] makeHash(byte[] sourceBytes) {
        return this.cryptoSource.getMessageDigest().digest(sourceBytes);
    }

    @Override
    public SecureRandom rnd() {
        return this.cryptoSource.getRandom();
    }

    private static class ManyBlocks
    implements EncryptedData,
    Serializable {
        byte[] encryptedSymmetricKey;
        final List<byte[]> blockList = new ArrayList<byte[]>();

        private ManyBlocks() {
        }

        @Override
        public void encryptAndSet(byte[] bytes, CryptoSource cryptoSource) {
            byte[] symmetricKey = new byte[cryptoSource.getBlockSize()];
            cryptoSource.getRandom().nextBytes(symmetricKey);
            this.encryptedSymmetricKey = CryptoBridge.encryptBlock(symmetricKey, cryptoSource);
            CryptoBridge.writeToBlockList(this.blockList, symmetricKey, bytes);
        }

        @Override
        public byte[] decryptAndGet(CryptoSource cryptoSource) {
            byte[] symmetricKey = CryptoBridge.decryptBlock(this.encryptedSymmetricKey, cryptoSource);
            if (symmetricKey == null) {
                return null;
            }
            return CryptoBridge.readFromBlockList(this.blockList, symmetricKey);
        }
    }

    private static class SmallBlock
    implements EncryptedData,
    Serializable {
        byte[] encryptedBytes;

        private SmallBlock() {
        }

        @Override
        public void encryptAndSet(byte[] bytes, CryptoSource cryptoSource) {
            this.encryptedBytes = CryptoBridge.encryptBlock(bytes, cryptoSource);
        }

        @Override
        public byte[] decryptAndGet(CryptoSource cryptoSource) {
            return CryptoBridge.decryptBlock(this.encryptedBytes, cryptoSource);
        }
    }

    private static interface EncryptedData {
        public void encryptAndSet(byte[] var1, CryptoSource var2);

        public byte[] decryptAndGet(CryptoSource var1);
    }
}

