/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import kz.greetgo.security.errors.SerializedClassChanged;
import kz.greetgo.security.session.SessionGenId;
import kz.greetgo.security.session.SessionId;
import kz.greetgo.security.session.SessionIdentity;
import kz.greetgo.security.session.SessionRow;
import kz.greetgo.security.session.SessionService;
import kz.greetgo.security.session.SessionServiceBuilder;
import kz.greetgo.security.session.SessionValidator;
import kz.greetgo.security.session.touch.PendingTouch;

class SessionServiceImpl
implements SessionService {
    private final SessionServiceBuilder builder;
    private final PendingTouch pendingTouch;

    public SessionServiceImpl(SessionServiceBuilder builder) {
        this.builder = builder;
        this.pendingTouch = new PendingTouch(() -> builder.nowSupplier.get(), () -> builder.delayTouchSyncMs.getAsLong(), (id, date) -> builder.storage.setLastTouchedAt(id, date));
    }

    @Override
    public SessionIdentity createSession(Object sessionData) {
        String sessionIdPart = SessionGenId.generate(this.builder.sessionIdLength);
        String sessionSalt = this.builder.saltGenerator.generateSalt(sessionIdPart);
        String sessionId = new SessionId(sessionSalt, sessionIdPart).toString();
        String token = SessionGenId.generate(this.builder.tokenLength);
        SessionIdentity identity = new SessionIdentity(sessionId, token);
        this.builder.storage.insertSession(identity, sessionData);
        this.builder.storage.setLastTouchedAt(identity.id, this.builder.nowSupplier.get());
        return identity;
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    @Override
    public <T> T getSessionData(String sessionId) {
        return SessionServiceImpl.cast(this.getSession(sessionId).map(row -> row.sessionData).orElse(null));
    }

    private Optional<SessionRow> getSession(String sessionId) {
        return this.builder.sessionCache.get(sessionId, () -> this.loadSession(sessionId)).map(sessionRow -> this.touchSession(sessionId, (SessionRow)sessionRow));
    }

    private SessionRow touchSession(String sessionId, SessionRow x) {
        this.pendingTouch.touch(sessionId);
        return x;
    }

    private Optional<SessionRow> loadSession(String sessionId) {
        try {
            SessionRow sessionRow = this.builder.storage.loadSession(sessionId);
            if (sessionRow == null) {
                return Optional.empty();
            }
            if (this.isInvalidSession(sessionId, sessionRow.sessionData, sessionRow.token)) {
                this.removeSession(sessionId);
                return Optional.empty();
            }
            return Optional.of(sessionRow);
        }
        catch (SerializedClassChanged e) {
            return Optional.empty();
        }
    }

    private boolean isInvalidSession(String sessionId, Object sessionData, String token) {
        return !this.isValidSession(sessionId, sessionData, token);
    }

    private boolean isValidSession(String sessionId, Object sessionData, String token) {
        SessionValidator<Object> sessionValidator = this.builder.sessionValidator;
        if (sessionValidator == null) {
            return true;
        }
        try {
            sessionValidator.validate(sessionId, sessionData, token);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean verifyId(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        SessionId s = SessionId.parse(sessionId);
        if (s == null) {
            return false;
        }
        if (s.part == null || s.part.isEmpty()) {
            return false;
        }
        if (s.salt == null || s.salt.isEmpty()) {
            return false;
        }
        return this.builder.saltGenerator.validateSalt(s.part, s.salt);
    }

    @Override
    public boolean verifyToken(String sessionId, String token) {
        return this.getSession(sessionId).filter(row -> row.token != null && row.token.equals(token)).isPresent();
    }

    @Override
    public Optional<String> getToken(String sessionId) {
        return this.getSession(sessionId).map(x -> x.token);
    }

    @Override
    public void removeSession(String sessionId) {
        if (!this.verifyId(sessionId)) {
            return;
        }
        this.builder.storage.remove(sessionId);
        this.builder.sessionCache.invalidate(sessionId);
    }

    @Override
    public void removeOldSessions(int hoursOld) {
        this.builder.storage.removeSessionsOlderThan(hoursOld);
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(10, -hoursOld);
    }

    @Override
    public void idle() {
        this.pendingTouch.idle();
    }

    @Override
    public void close() {
        this.pendingTouch.close();
    }
}

