/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto;

import com.mongodb.client.MongoCollection;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.crypto.CryptoBuilder;
import kz.greetgo.security.crypto.MongoContentAccess;
import org.bson.Document;

public class CryptoBuilderKeysInMongo {
    private final CryptoBuilder parent;
    private final MongoCollection<Document> forPrivateKey;
    private final MongoCollection<Document> forPublicKey;
    private final Names privateKeyNames = new Names();
    private final Names publicKeyNames = new Names();

    public CryptoBuilderKeysInMongo(CryptoBuilder parent, MongoCollection<Document> forPrivateKey, MongoCollection<Document> forPublicKey) {
        this.privateKeyNames.idValue = "private_key";
        this.publicKeyNames.idValue = "public_key";
        this.parent = parent;
        this.forPrivateKey = forPrivateKey;
        this.forPublicKey = forPublicKey;
    }

    public CryptoBuilderKeysInMongo setKeysFieldName(String fieldName) {
        return this.setPrivateKeyFieldName(fieldName).setPublicKeyFieldName(fieldName);
    }

    public CryptoBuilderKeysInMongo setPrivateKeyFieldName(String fieldName) {
        this.privateKeyNames.keyFieldName = fieldName;
        return this;
    }

    public CryptoBuilderKeysInMongo setPublicKeyFieldName(String fieldName) {
        this.publicKeyNames.keyFieldName = fieldName;
        return this;
    }

    public CryptoBuilderKeysInMongo setIdFieldName(String fieldName) {
        return this.setPrivateIdFieldName(fieldName).setPublicIdFieldName(fieldName);
    }

    public CryptoBuilderKeysInMongo setPrivateId(String idValue) {
        this.privateKeyNames.idValue = idValue;
        return this;
    }

    public CryptoBuilderKeysInMongo setPublicId(String idValue) {
        this.publicKeyNames.idValue = idValue;
        return this;
    }

    public CryptoBuilderKeysInMongo setPrivateIdFieldName(String fieldName) {
        this.privateKeyNames.idFieldName = fieldName;
        return this;
    }

    public CryptoBuilderKeysInMongo setPublicIdFieldName(String fieldName) {
        this.publicKeyNames.idFieldName = fieldName;
        return this;
    }

    public Crypto build() {
        MongoContentAccess privateKeyAccess = new MongoContentAccess(this.forPrivateKey, this.privateKeyNames);
        MongoContentAccess publicKeyAccess = new MongoContentAccess(this.forPublicKey, this.publicKeyNames);
        return this.parent.build(privateKeyAccess, publicKeyAccess);
    }

    static class Names {
        String idFieldName = "id";
        String keyFieldName = "keyContent";
        String idValue;

        Names() {
        }

        public String toString() {
            return "Names{idFieldName='" + this.idFieldName + "', keyFieldName='" + this.keyFieldName + "', idValue='" + this.idValue + "'}";
        }
    }
}

