/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import kz.greetgo.db.Jdbc;
import kz.greetgo.security.crypto.ContentAccess;
import kz.greetgo.security.crypto.errors.SqlWrapper;
import kz.greetgo.security.crypto.jdbc.ContentNames;
import kz.greetgo.security.crypto.jdbc.DbDialect;
import kz.greetgo.security.util.ErrorUtil;

public class JdbcContentAccess
implements ContentAccess {
    private final Jdbc jdbc;
    private final ContentNames names;
    private final String createTableDdl;
    private final DbDialect dialect;

    public JdbcContentAccess(Jdbc jdbc, ContentNames names, String createTableDdl, DbDialect dialect) {
        this.jdbc = jdbc;
        this.names = names;
        this.createTableDdl = createTableDdl;
        this.dialect = dialect;
    }

    @Override
    public byte[] downloadBytes() {
        return (byte[])this.jdbc.execute(con -> {
            String sql = "select " + this.names.valueFieldName + " from " + this.names.tableName + " where " + this.names.idFieldName + " = ?";
            try (PreparedStatement ps = con.prepareStatement(sql);){
                byte[] byArray;
                block16: {
                    ResultSet rs;
                    block14: {
                        byte[] byArray2;
                        block15: {
                            ps.setString(1, this.names.idValue);
                            rs = ps.executeQuery();
                            try {
                                if (rs.next()) break block14;
                                byArray2 = null;
                                if (rs == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return byArray2;
                    }
                    byArray = rs.getBytes(1);
                    if (rs == null) break block16;
                    rs.close();
                }
                return byArray;
            }
        });
    }

    @Override
    public void uploadBytes(byte[] bytes) {
        this.jdbc.execute(con -> {
            try {
                if (bytes == null) {
                    this.delete(con);
                    return null;
                }
                if (this.update(con, bytes) > 0) {
                    return null;
                }
            }
            catch (SQLException e) {
                if (this.dialect.isNoTable(e)) {
                    this.createTable(con);
                }
                throw new SqlWrapper(e);
            }
            try {
                this.insert(con, bytes);
            }
            catch (SQLException e) {
                if (this.dialect.isRecordAlreadyExists(e)) {
                    this.update(con, bytes);
                }
                throw new SqlWrapper(e);
            }
            return null;
        });
    }

    private void delete(Connection con) throws SQLException {
        String sql = "delete from " + this.names.tableName + " where " + this.names.idFieldName + " = ?";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setString(1, this.names.idValue);
            ps.executeUpdate();
        }
    }

    private void createTable(Connection con) throws SQLException {
        try (PreparedStatement ps = con.prepareStatement(this.createTableDdl);){
            ps.executeUpdate();
        }
    }

    private int update(Connection con, byte[] bytes) throws SQLException {
        String sql = "update " + this.names.tableName + " set " + this.names.valueFieldName + " = ? where " + this.names.idFieldName + " = ?";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setBytes(1, bytes);
            ps.setString(2, this.names.idValue);
            int n = ps.executeUpdate();
            return n;
        }
    }

    private void insert(Connection con, byte[] bytes) throws SQLException {
        String sql = "insert into " + this.names.tableName + " (" + this.names.idFieldName + ", " + this.names.valueFieldName + ") values (?, ?)";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setString(1, this.names.idValue);
            ps.setBytes(2, bytes);
            ps.executeUpdate();
        }
    }

    @Override
    public boolean exists() {
        return (Boolean)this.jdbc.execute(con -> {
            try {
                return this.checkExists(con);
            }
            catch (Exception e) {
                SQLException sqlException = ErrorUtil.extractSqlException(e);
                if (sqlException != null && this.dialect.isNoTable(sqlException)) {
                    this.createTable(con);
                    return this.checkExists(con);
                }
                throw e;
            }
        });
    }

    private Boolean checkExists(Connection con) throws SQLException {
        String sql = "select count(1) from " + this.names.tableName + " where " + this.names.idFieldName + " = ?";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            Boolean bl;
            block13: {
                ps.setString(1, this.names.idValue);
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new RuntimeException("FATAL ERROR");
                    }
                    bl = rs.getInt(1) > 0;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }
}

