package kz.greetgo.security.session;

import java.sql.SQLException;
import java.util.List;

class SessionStoragePostgresAdapter extends SessionStorageAdapterAbstract implements SessionStorage {
  SessionStoragePostgresAdapter(SessionStorageJdbcBuilder.Names names,
                                SessionSerializer sessionSerializer) {
    super(names, sessionSerializer);
  }

  @Override
  protected String checkTableExistsSql() {
    return "select " + names.id + " from " + names.tableName + " limit 1";
  }

  @Override
  protected String insertSessionSql(List<Object> sqlParams,
                                    SessionIdentity identity,
                                    Object sessionData,
                                    String samenessId) {
    sqlParams.add(identity.id);
    sqlParams.add(identity.token);
    sqlParams.add(sessionSerializer.serializeToStr(sessionData));
    sqlParams.add(samenessId);

    return "insert into " + names.tableName + " (" +
      names.id +
      ", " +
      names.token +
      ", " +
      names.sessionData +
      ", " +
      names.samenessId +
      ") values (?, ?, ?, ?)";
  }

  @Override
  protected String createSessionTableSql() {
    return "create table " + names.tableName + " (" +
      "  " + names.id + " varchar(50) not null," +
      "  " + names.token + " varchar(50)," +
      "  " + names.sessionData + " text," +
      "  " + names.insertedAt + " timestamp not null default clock_timestamp()," +
      "  " + names.lastTouchedAt + " timestamp not null default clock_timestamp()," +
      "  " + names.samenessId + " varchar(150)," +
      "  primary key(" + names.id + ")" +
      ")";
  }

  @Override
  protected String createSessionTableIndexesSql() {
    return "create index if not exists idx_" + names.samenessId + " on " + names.tableName + " (" + names.samenessId + ")";
  }

  @Override
  protected boolean isExceptionAboutTableDoesNotExists(SQLException sqlException) {
    return "42P01".equals(sqlException.getSQLState());
  }

  @Override
  protected String loadLastTouchedAtSql(List<Object> sqlParams, String sessionId) {
    sqlParams.add(sessionId);
    return "select " + names.lastTouchedAt + " from " + names.tableName + " where " + names.id + " = ?";
  }

  @Override
  protected String zeroSessionAgeSql(List<Object> sqlParams, String sessionId) {
    sqlParams.add(sessionId);
    return "update " + names.tableName
      + " set " + names.lastTouchedAt + " = clock_timestamp()" +
      " where " + names.id + " = ?";
  }

  @Override
  protected String removeSessionsOlderThanSql(List<Object> sqlParams, int ageInHours) {
    return "delete from " + names.tableName + " where " + names.lastTouchedAt
      + " < clock_timestamp() - interval '" + ageInHours + " hours'";
  }

  @Override
  protected String removeSamenessSessions(List<Object> sqlParams, String samenessId) {
    sqlParams.add(samenessId);
    return "delete from " + names.tableName + " where " + names.samenessId + " = ?";
  }
}
