/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.crypto.jdbc;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.stream.Collectors;
import kz.greetgo.security.crypto.jdbc.DbDialect;
import kz.greetgo.security.crypto.jdbc.create_table.CreateTable;
import kz.greetgo.security.crypto.jdbc.create_table.CreatingField;
import kz.greetgo.security.crypto.jdbc.create_table.FieldType;

public abstract class AbstractDbDialect
implements DbDialect {
    @Override
    public String generateCreateTableDDL(CreateTable createTable) {
        ArrayList<CallSite> fieldStrList = new ArrayList<CallSite>();
        ArrayList<String> primaryKeyNames = new ArrayList<String>();
        for (CreatingField f : createTable.creatingFields) {
            if (f.primaryKey) {
                primaryKeyNames.add(f.name);
            }
            fieldStrList.add((CallSite)((Object)(f.name + " " + this.typeToStr(f.type, f.length) + (f.notNull ? " not null" : ""))));
        }
        if (primaryKeyNames.size() > 0) {
            fieldStrList.add((CallSite)((Object)("primary key (" + primaryKeyNames.stream().collect(Collectors.joining(", ")) + ")")));
        }
        return "create table " + createTable.tableName + " (" + fieldStrList.stream().collect(Collectors.joining(", ")) + ")";
    }

    protected abstract String typeToStr(FieldType var1, int var2);
}

