/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.util.Date;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import kz.greetgo.security.crypto.Crypto;
import kz.greetgo.security.session.NoSessionCache;
import kz.greetgo.security.session.SaltGenerator;
import kz.greetgo.security.session.SaltGeneratorCryptoBridge;
import kz.greetgo.security.session.SessionCache;
import kz.greetgo.security.session.SessionLog;
import kz.greetgo.security.session.SessionService;
import kz.greetgo.security.session.SessionServiceImpl;
import kz.greetgo.security.session.SessionStorage;
import kz.greetgo.security.session.SessionValidator;

public class SessionServiceBuilder {
    SessionStorage storage;
    SaltGenerator saltGenerator;
    SessionCache sessionCache = new NoSessionCache();
    int sessionIdLength = 15;
    int tokenLength = 15;
    LongSupplier delayTouchSyncMs = () -> 4700L;
    SessionValidator<Object> sessionValidator = null;
    SessionLog sessionLog = Throwable::printStackTrace;
    Supplier<Date> nowSupplier = Date::new;
    private boolean built = false;

    private SessionServiceBuilder() {
    }

    public static SessionServiceBuilder newBuilder() {
        return new SessionServiceBuilder();
    }

    public <T> SessionServiceBuilder sessionValidator(SessionValidator<T> sessionValidator) {
        this.checkBuilt();
        this.sessionValidator = sessionValidator;
        return this;
    }

    public SessionServiceBuilder sessionLog(SessionLog sessionLog) {
        this.checkBuilt();
        this.sessionLog = Objects.requireNonNull(sessionLog, "CMNjR6SkFq :: sessionLog");
        return this;
    }

    public SessionServiceBuilder setDelayTouchSyncMs(LongSupplier delayTouchSyncMs) {
        this.delayTouchSyncMs = delayTouchSyncMs;
        return this;
    }

    public SessionServiceBuilder setSessionCache(SessionCache sessionCache) {
        this.sessionCache = sessionCache;
        return this;
    }

    public SessionServiceBuilder setStorage(SessionStorage storage) {
        this.checkBuilt();
        this.storage = storage;
        return this;
    }

    private void checkBuilt() {
        if (this.built) {
            throw new RuntimeException("00vy8Th268 :: Already built");
        }
    }

    public SessionServiceBuilder setSaltGenerator(SaltGenerator saltGenerator) {
        this.checkBuilt();
        this.saltGenerator = saltGenerator;
        return this;
    }

    public SessionServiceBuilder setNowSupplier(Supplier<Date> nowSupplier) {
        this.checkBuilt();
        this.nowSupplier = nowSupplier;
        return this;
    }

    public SessionServiceBuilder setSaltGeneratorOnCrypto(Crypto crypto) {
        return this.setSaltGeneratorOnCrypto(crypto, 32);
    }

    public SessionServiceBuilder setSaltGeneratorOnCrypto(Crypto crypto, int rndLength) {
        this.checkBuilt();
        this.saltGenerator = new SaltGeneratorCryptoBridge(crypto, rndLength);
        return this;
    }

    public SessionServiceBuilder setSessionIdLength(int sessionIdLength) {
        this.checkBuilt();
        this.sessionIdLength = sessionIdLength;
        return this;
    }

    public SessionServiceBuilder setTokenLength(int tokenLength) {
        this.checkBuilt();
        this.tokenLength = tokenLength;
        return this;
    }

    public SessionService build() {
        this.built = true;
        if (this.storage == null) {
            throw new RuntimeException("lNUic2LKvg :: No sessionStorage");
        }
        if (this.saltGenerator == null) {
            throw new RuntimeException("h1tmyAyHG2 :: No saltGenerator");
        }
        return new SessionServiceImpl(this);
    }
}

