/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.util.Objects;
import kz.greetgo.db.DbType;
import kz.greetgo.db.Jdbc;
import kz.greetgo.security.session.SessionSerializer;
import kz.greetgo.security.session.SessionStorage;
import kz.greetgo.security.session.SessionStorageOracleAdapter;
import kz.greetgo.security.session.SessionStoragePostgresAdapter;

public class SessionStorageJdbcBuilder {
    private final DbType dbType;
    private final SessionSerializer sessionSerializer;
    final Names names = new Names();

    SessionStorageJdbcBuilder(DbType dbType, Jdbc jdbc, SessionSerializer sessionSerializer) {
        this.sessionSerializer = sessionSerializer;
        Objects.requireNonNull(dbType);
        Objects.requireNonNull(jdbc);
        this.dbType = dbType;
        this.names.jdbc = jdbc;
    }

    public SessionStorage build() {
        if (this.dbType == DbType.Postgres) {
            return new SessionStoragePostgresAdapter(this.names, this.sessionSerializer);
        }
        if (this.dbType == DbType.Oracle) {
            return new SessionStorageOracleAdapter(this.names, this.sessionSerializer);
        }
        throw new RuntimeException("Qxz0GJVfYM :: Unknown db type = " + this.dbType);
    }

    public SessionStorageJdbcBuilder setTableName(String tableName) {
        this.names.tableName = tableName;
        return this;
    }

    public SessionStorageJdbcBuilder setFieldId(String id) {
        this.names.id = id;
        return this;
    }

    public SessionStorageJdbcBuilder setFieldToken(String token) {
        this.names.token = token;
        return this;
    }

    public SessionStorageJdbcBuilder setFieldSessionData(String sessionData) {
        this.names.sessionData = sessionData;
        return this;
    }

    public SessionStorageJdbcBuilder setFieldInsertedAt(String insertedAt) {
        this.names.insertedAt = insertedAt;
        return this;
    }

    public SessionStorageJdbcBuilder setFieldLastTouchedAt(String lastTouchedAt) {
        this.names.lastTouchedAt = lastTouchedAt;
        return this;
    }

    public SessionStorageJdbcBuilder setFieldSamenessId(String samenessId) {
        this.names.samenessId = samenessId;
        return this;
    }

    static class Names {
        Jdbc jdbc = null;
        String tableName = "session_storage";
        String id = "id";
        String token = "token";
        String sessionData = "session_data";
        String insertedAt = "inserted_at";
        String lastTouchedAt = "last_touched_at";
        String samenessId = "sameness_id";

        Names() {
        }
    }
}

