/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kz.greetgo.security.session.SessionIdentity;
import kz.greetgo.security.session.SessionRow;
import kz.greetgo.security.session.SessionSerializer;
import kz.greetgo.security.session.SessionStorage;
import kz.greetgo.security.util.MongoUtil;
import org.bson.Document;
import org.bson.conversions.Bson;

class SessionStorageMongo
implements SessionStorage {
    private final MongoCollection<Document> collection;
    private final SessionSerializer sessionSerializer;
    private final Names names = new Names();
    private final AtomicBoolean wasEnsureIndexId = new AtomicBoolean(false);

    public String toString() {
        return "SessionStorageMongo{" + this.collection.getNamespace() + "}";
    }

    public SessionStorageMongo(MongoCollection<Document> collection, SessionSerializer sessionSerializer) {
        this.collection = collection;
        this.sessionSerializer = sessionSerializer;
    }

    private void ensureIndexId() {
        if (this.wasEnsureIndexId.get()) {
            return;
        }
        BasicDBObject cmd = new BasicDBObject();
        cmd.append(this.names.id, (Object)1);
        cmd.append(this.names.samenessId, (Object)1);
        this.collection.createIndex((Bson)cmd);
        this.wasEnsureIndexId.set(true);
    }

    @Override
    public void insertSession(SessionIdentity identity, Object sessionData, String samenessId) {
        Objects.requireNonNull(identity, "identity");
        Objects.requireNonNull(identity.id, "identity.id");
        this.ensureIndexId();
        String sessionDataStr = this.sessionSerializer.serializeToStr(sessionData);
        Document insert = new Document();
        insert.append(this.names.id, (Object)identity.id);
        insert.append(this.names.token, (Object)identity.token);
        insert.append(this.names.sessionData, (Object)sessionDataStr);
        insert.append(this.names.insertedAt, (Object)new Date());
        insert.append(this.names.lastModifiedAt, (Object)new Date());
        insert.append(this.names.actual, (Object)1);
        insert.append(this.names.samenessId, (Object)samenessId);
        this.collection.insertOne((Object)insert);
    }

    @Override
    public SessionRow loadSession(String sessionId) {
        this.ensureIndexId();
        Document found = (Document)this.collection.find(this.filterById(sessionId)).limit(1).first();
        if (found == null) {
            return null;
        }
        String token = MongoUtil.toStr(found.get((Object)this.names.token));
        Object sessionData = this.sessionSerializer.deserializeFromStr(MongoUtil.toStr(found.get((Object)this.names.sessionData)));
        Date insertedAt = MongoUtil.toDate(found.get((Object)this.names.insertedAt));
        Date lastTouchedAt = MongoUtil.toDate(found.get((Object)this.names.lastModifiedAt));
        String samenessId = MongoUtil.toStr(found.get((Object)this.names.samenessId));
        return new SessionRow(token, sessionData, insertedAt, lastTouchedAt, samenessId);
    }

    private Bson filterById(String sessionId) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)this.names.id, (Object)sessionId), Filters.eq((String)this.names.actual, (Object)1)});
    }

    @Override
    public Date loadLastTouchedAt(String sessionId) {
        this.ensureIndexId();
        Document found = (Document)this.collection.find(this.filterById(sessionId)).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{this.names.lastModifiedAt})})).limit(1).first();
        if (found == null) {
            return null;
        }
        return MongoUtil.toDate(found.get((Object)this.names.lastModifiedAt));
    }

    @Override
    public int removeSessionsOlderThan(int ageInHours) {
        this.ensureIndexId();
        Document values = new Document();
        values.append(this.names.actual, (Object)0);
        Document update = new Document();
        update.append("$set", (Object)values);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(10, -ageInHours);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.lt((String)this.names.lastModifiedAt, (Object)calendar.getTime()), Filters.eq((String)this.names.actual, (Object)1)});
        return (int)this.collection.updateMany(filter, (Bson)update).getMatchedCount();
    }

    @Override
    public boolean remove(String sessionId) {
        this.ensureIndexId();
        Document values = new Document();
        values.append(this.names.actual, (Object)0);
        Document update = new Document();
        update.append("$set", (Object)values);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)this.names.id, (Object)sessionId), Filters.eq((String)this.names.actual, (Object)1)});
        return (int)this.collection.updateMany(filter, (Bson)update).getMatchedCount() > 0;
    }

    @Override
    public boolean setLastTouchedAt(String sessionId, Date lastTouchedAt) {
        this.ensureIndexId();
        Document values = new Document();
        values.append(this.names.lastModifiedAt, (Object)lastTouchedAt);
        Document update = new Document();
        update.append("$set", (Object)values);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)this.names.id, (Object)sessionId), Filters.eq((String)this.names.actual, (Object)1)});
        return (int)this.collection.updateMany(filter, (Bson)update).getMatchedCount() > 0;
    }

    @Override
    public int removeSamenessSessions(String samenessId) {
        this.ensureIndexId();
        Document values = new Document();
        values.append(this.names.actual, (Object)0);
        Document update = new Document();
        update.append("$set", (Object)values);
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)this.names.samenessId, (Object)samenessId), Filters.eq((String)this.names.actual, (Object)1)});
        return (int)this.collection.updateMany(filter, (Bson)update).getMatchedCount();
    }

    static class Names {
        String id = "id";
        String sessionData = "sessionData";
        String lastModifiedAt = "lastModifiedAt";
        String insertedAt = "insertedAt";
        String token = "token";
        String actual = "actual";
        String samenessId = "samenessId";

        Names() {
        }
    }
}

