/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.security.session;

import java.sql.SQLException;
import java.util.List;
import kz.greetgo.security.session.SessionIdentity;
import kz.greetgo.security.session.SessionSerializer;
import kz.greetgo.security.session.SessionStorage;
import kz.greetgo.security.session.SessionStorageAdapterAbstract;
import kz.greetgo.security.session.SessionStorageJdbcBuilder;

class SessionStoragePostgresAdapter
extends SessionStorageAdapterAbstract
implements SessionStorage {
    SessionStoragePostgresAdapter(SessionStorageJdbcBuilder.Names names, SessionSerializer sessionSerializer) {
        super(names, sessionSerializer);
    }

    @Override
    protected String checkTableExistsSql() {
        return "select " + this.names.id + " from " + this.names.tableName + " limit 1";
    }

    @Override
    protected String insertSessionSql(List<Object> sqlParams, SessionIdentity identity, Object sessionData, String samenessId) {
        sqlParams.add(identity.id);
        sqlParams.add(identity.token);
        sqlParams.add(this.sessionSerializer.serializeToStr(sessionData));
        sqlParams.add(samenessId);
        return "insert into " + this.names.tableName + " (" + this.names.id + ", " + this.names.token + ", " + this.names.sessionData + ", " + this.names.samenessId + ") values (?, ?, ?, ?)";
    }

    @Override
    protected String createSessionTableSql() {
        return "create table " + this.names.tableName + " (  " + this.names.id + " varchar(50) not null,  " + this.names.token + " varchar(50),  " + this.names.sessionData + " text,  " + this.names.insertedAt + " timestamp not null default clock_timestamp(),  " + this.names.lastTouchedAt + " timestamp not null default clock_timestamp(),  " + this.names.samenessId + " varchar(150),  primary key(" + this.names.id + "))";
    }

    @Override
    protected String createSessionTableIndexesSql() {
        return "create index if not exists idx_" + this.names.samenessId + " on " + this.names.tableName + " (" + this.names.samenessId + ")";
    }

    @Override
    protected boolean isExceptionAboutTableDoesNotExists(SQLException sqlException) {
        return "42P01".equals(sqlException.getSQLState());
    }

    @Override
    protected String loadLastTouchedAtSql(List<Object> sqlParams, String sessionId) {
        sqlParams.add(sessionId);
        return "select " + this.names.lastTouchedAt + " from " + this.names.tableName + " where " + this.names.id + " = ?";
    }

    @Override
    protected String zeroSessionAgeSql(List<Object> sqlParams, String sessionId) {
        sqlParams.add(sessionId);
        return "update " + this.names.tableName + " set " + this.names.lastTouchedAt + " = clock_timestamp() where " + this.names.id + " = ?";
    }

    @Override
    protected String removeSessionsOlderThanSql(List<Object> sqlParams, int ageInHours) {
        return "delete from " + this.names.tableName + " where " + this.names.lastTouchedAt + " < clock_timestamp() - interval '" + ageInHours + " hours'";
    }

    @Override
    protected String removeSamenessSessions(List<Object> sqlParams, String samenessId) {
        sqlParams.add(samenessId);
        return "delete from " + this.names.tableName + " where " + this.names.samenessId + " = ?";
    }
}

