package kz.greetgo.spring.websocket.controller;

import kz.greetgo.spring.websocket.util.ConvertUtil;
import org.jetbrains.annotations.NotNull;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

import static java.util.Objects.requireNonNullElse;

public class ExecuteInput {
  public final @NotNull Supplier<String> sessionIdSupplier;
  public final Map<String, Object> params;

  private ExecuteInput(@NotNull Supplier<String> sessionIdSupplier, Map<String, Object> params) {
    this.sessionIdSupplier = sessionIdSupplier;
    this.params = params;
  }

  public static Builder builder() {
    return new Builder();
  }

  private static final Supplier<String> RETURNS_NULL = () -> null;

  public static class Builder {
    private final Map<String, Object> params = new HashMap<>();
    private Supplier<String> sessionIdSupplier = RETURNS_NULL;

    private Builder() {}

    public Builder setParams(Map<String, Object> params) {
      this.params.clear();
      if (params != null) {
        this.params.putAll(params);
      }
      return this;
    }

    public Builder param(String key, Object value) {
      params.put(key, value);
      return this;
    }

    public Builder sessionIdSupplier(Supplier<String> sessionIdSupplier) {
      this.sessionIdSupplier = requireNonNullElse(sessionIdSupplier, RETURNS_NULL);
      return this;
    }

    public @NotNull ExecuteInput build() {
      return new ExecuteInput(sessionIdSupplier, Collections.unmodifiableMap(params));
    }
  }

  private Object getParamValue(String prmName) {
    return this.params.get(prmName);
  }

  public Object getParamConvertedToType(String prmName, Class<?> parameterType, Type genericParameterType) {
    return ConvertUtil.convertToType(getParamValue(prmName), parameterType, genericParameterType);
  }

}
