package kz.greetgo.spring.websocket.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodParamUtil {

  public static Annotation[][] getAllParameterAnnotations(Method method) {

    List<List<Annotation>> listList = new ArrayList<>();

    while (true) {
      Annotation[][] parameterAnnotations = method.getParameterAnnotations();
      for (int i = 0; i < parameterAnnotations.length; i++) {
        Annotation[] parameterAnnotation = parameterAnnotations[i];
        if (listList.size() <= i) {
          listList.add(new ArrayList<>());
        }
        for (Annotation annotation : parameterAnnotation) {
          listList.get(i).add(annotation);
        }
      }

      Class<?> superclass = method.getDeclaringClass().getSuperclass();

      if (superclass == null) {
        return convertToArray(listList);
      }

      try {
        method = superclass.getMethod(method.getName(), method.getParameterTypes());
      } catch (NoSuchMethodException e) {
        return convertToArray(listList);
      }

    }
  }

  private static Annotation[][] convertToArray(List<List<Annotation>> listList) {
    Annotation[][] ret = new Annotation[listList.size()][];
    for (int i = 0; i < listList.size(); i++) {
      List<Annotation> list = listList.get(i);
      int size = list.size();
      ret[i] = new Annotation[size];
      for (int j = 0; j < size; j++) {
        ret[i][j] = list.get(j);
      }
    }
    return ret;
  }

}
