/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.spring.websocket.beans;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kz.greetgo.spring.websocket.controller.AnnotationFinder;
import kz.greetgo.spring.websocket.controller.ControllerManager;
import kz.greetgo.spring.websocket.controller.ExecuteInput;
import kz.greetgo.spring.websocket.controller.PreExecuteInterceptor;
import kz.greetgo.spring.websocket.interfaces.MessageSender;
import kz.greetgo.spring.websocket.interfaces.NeedClose;
import kz.greetgo.spring.websocket.interfaces.WebsocketController;
import kz.greetgo.spring.websocket.model.ToClient;
import kz.greetgo.spring.websocket.model.ToServer;
import kz.greetgo.spring.websocket.util.ConsoleColors;
import kz.greetgo.spring.websocket.util.LoggingUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public abstract class AbstractWebSocketHandlerBean<UserSessionData extends NeedClose>
extends AbstractWebSocketHandler
implements InitializingBean,
PreExecuteInterceptor {
    private final ConcurrentHashMap<String, SessionData<UserSessionData>> sessionMap = new ConcurrentHashMap();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Logger callingLog = LoggingUtil.callingLog;
    private final ControllerManager controllerManager = new ControllerManager();
    @Autowired
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        this.controllerManager.setPreExecuteInterceptorSupplier(() -> this);
        Collection controllers = this.applicationContext.getBeansWithAnnotation(WebsocketController.class).values();
        for (Object controller : controllers) {
            this.controllerManager.registerController(controller);
        }
    }

    public void handleTransportError(@NotNull WebSocketSession session, @NotNull Throwable exception) {
        this.log.error("0hbnSRlbME :: TransportError in " + session, exception);
    }

    public void afterConnectionEstablished(@NotNull WebSocketSession webSocketSession) {
        UserSessionData userData;
        SessionData oldSessionData;
        SessionData sessionData = new SessionData(webSocketSession);
        if (callingLog.isInfoEnabled()) {
            callingLog.info(ConsoleColors.GREEN_BOLD() + "OPEN SESS " + ConsoleColors.RESET() + webSocketSession.getId());
        }
        if ((oldSessionData = this.sessionMap.put(webSocketSession.getId(), sessionData)) != null) {
            this.closeSession(webSocketSession.getId(), oldSessionData);
        }
        if ((userData = this.createUserDataOnNewSession(webSocketSession.getId())) != null) {
            sessionData.userData.set(userData);
        }
    }

    protected UserSessionData createUserDataOnNewSession(String sessionId) {
        return null;
    }

    private void closeSession(@NotNull String sessionId, @NotNull SessionData<UserSessionData> sessionData) {
        try {
            sessionData.webSocketSession.close();
            NeedClose userSessionData = (NeedClose)sessionData.userData.get();
            this.closeUserSessionData(sessionId, userSessionData);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected void closeUserSessionData(@NotNull String sessionId, UserSessionData userSessionData) throws Exception {
        if (userSessionData != null) {
            userSessionData.close();
        }
    }

    public void afterConnectionClosed(@NotNull WebSocketSession session, @NotNull CloseStatus status) {
        if (callingLog.isInfoEnabled()) {
            callingLog.info(ConsoleColors.RED_BOLD() + "CLOS SESS " + ConsoleColors.RESET() + session.getId());
        }
        this.removeSessionById(session.getId());
    }

    protected void removeSessionById(String sessionId) {
        SessionData<UserSessionData> sessionData = this.sessionMap.remove(sessionId);
        if (sessionData != null) {
            this.closeSession(sessionId, sessionData);
        }
    }

    protected void handleTextMessage(@NotNull WebSocketSession session, @NotNull TextMessage message) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ToServer toServer = (ToServer)objectMapper.readValue((String)message.getPayload(), ToServer.class);
        ExecuteInput executeInput = ExecuteInput.builder().sessionIdSupplier(() -> ((WebSocketSession)session).getId()).setParams(toServer.params).build();
        if (callingLog.isInfoEnabled()) {
            callingLog.info(ConsoleColors.BLUE_BOLD() + "TO_SERVER" + ConsoleColors.RESET() + " " + session.getId() + " " + ConsoleColors.BLUE() + toServer.service + ConsoleColors.RESET() + " : " + toServer.params);
        }
        this.controllerManager.findAndExecuteService(toServer.service, executeInput);
    }

    public void sendToClient(@NotNull String sessionId, @NotNull ToClient toClient) {
        this.createMessageSender(sessionId).sendMessage(toClient);
    }

    @NotNull
    private SessionData<UserSessionData> sessionData(String sessionId) {
        SessionData<UserSessionData> sessionData = this.sessionMap.get(sessionId);
        if (sessionData == null) {
            throw new RuntimeException("77ioMM7DGw :: No session with id = " + sessionId);
        }
        return sessionData;
    }

    public String getToken(@NotNull String sessionId) {
        return this.sessionData((String)sessionId).token.get();
    }

    public void setToken(@NotNull String sessionId, String value) {
        this.sessionData((String)sessionId).token.set(value);
    }

    protected UserSessionData getUserSessionData(@NotNull String sessionId) {
        SessionData<UserSessionData> sessionData = this.sessionMap.get(sessionId);
        if (sessionData == null) {
            throw new RuntimeException("KT6TIfC8j2 :: No session with id = " + sessionId);
        }
        return (UserSessionData)((NeedClose)sessionData.userData.get());
    }

    protected void setUserSessionData(@NotNull String sessionId, UserSessionData userSessionData) {
        SessionData<UserSessionData> sessionData = this.sessionMap.get(sessionId);
        if (sessionData == null) {
            throw new RuntimeException("2p2euVyXsR :: No session with id = " + sessionId);
        }
        sessionData.userData.set(userSessionData);
    }

    @NotNull
    public MessageSender createMessageSender(@NotNull String sessionId) {
        return toClient -> {
            try {
                WebSocketSession webSocketSession;
                ObjectMapper objectMapper = new ObjectMapper();
                SessionData<UserSessionData> sessionData = this.sessionData(sessionId);
                WebSocketSession webSocketSession2 = webSocketSession = sessionData.webSocketSession;
                synchronized (webSocketSession2) {
                    webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)objectMapper.writeValueAsString((Object)toClient)));
                }
                if (callingLog.isInfoEnabled()) {
                    callingLog.info(ConsoleColors.PURPLE_BOLD() + "TO_CLIENT" + ConsoleColors.RESET() + " " + sessionId + " " + ConsoleColors.PURPLE() + toClient.service + ConsoleColors.RESET() + " : " + toClient.body);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public void preExecute(Object controller, Method method, String serviceFullName, ExecuteInput executeInput, AnnotationFinder annotationFinder) {
    }

    private static class SessionData<UserSessionData extends NeedClose> {
        final WebSocketSession webSocketSession;
        final AtomicReference<String> token = new AtomicReference();
        final AtomicReference<UserSessionData> userData = new AtomicReference();

        public SessionData(WebSocketSession webSocketSession) {
            this.webSocketSession = webSocketSession;
        }
    }
}

