/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.spring.websocket.mongo;

import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import java.util.ArrayList;
import java.util.List;

public class MongoErrorFilters {
    public static MongoExceptionFilters mongo(MongoException error) {
        return new MongoExceptionFilters(error);
    }

    public static class MongoExceptionFilters {
        private final List<IfIgnore> ignoreList = new ArrayList<IfIgnore>();
        private final MongoException error;

        private MongoExceptionFilters(MongoException error) {
            this.error = error;
        }

        public MongoExceptionFilters ignoreStateShouldBeOpened(boolean ignore) {
            if (ignore) {
                this.ignoreList.add(e -> {
                    if (!(e.getCause() instanceof IllegalStateException)) {
                        return false;
                    }
                    IllegalStateException i = (IllegalStateException)e.getCause();
                    return "state should be: open".equals(i.getMessage());
                });
            }
            return this;
        }

        public MongoExceptionFilters ignoreCursorHasBeenClosed(boolean ignore) {
            if (ignore) {
                this.ignoreList.add(e -> {
                    if (!(e.getCause() instanceof IllegalStateException)) {
                        return false;
                    }
                    IllegalStateException i = (IllegalStateException)e.getCause();
                    return "Cursor has been closed".equals(i.getMessage());
                });
            }
            return this;
        }

        public MongoExceptionFilters ignoreMongoInterrupted(boolean ignore) {
            if (ignore) {
                this.ignoreList.add(MongoInterruptedException.class::isInstance);
            }
            return this;
        }

        public void check() {
            for (IfIgnore ifIgnore : this.ignoreList) {
                if (!ifIgnore.ignore(this.error)) continue;
                return;
            }
            throw this.error;
        }

        static interface IfIgnore {
            public boolean ignore(MongoException var1);
        }
    }
}

