package kz.greetgo.spring.websocket.mongo;

import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;

import java.util.ArrayList;
import java.util.List;

public class MongoErrorFilters {

  public static class MongoExceptionFilters {
    interface IfIgnore {
      boolean ignore(MongoException e);
    }

    private MongoExceptionFilters(MongoException error) {this.error = error;}

    private final List<IfIgnore> ignoreList = new ArrayList<>();
    private final MongoException error;

    public MongoExceptionFilters ignoreStateShouldBeOpened(boolean ignore) {
      if (ignore) {
        ignoreList.add(e -> {

          if (!(e.getCause() instanceof IllegalStateException)) {
            return false;
          }

          IllegalStateException i = (IllegalStateException) e.getCause();

          return "state should be: open".equals(i.getMessage());
        });
      }
      return this;
    }

    public MongoExceptionFilters ignoreCursorHasBeenClosed(boolean ignore) {
      if (ignore) {
        ignoreList.add(e -> {

          if (!(e.getCause() instanceof IllegalStateException)) {
            return false;
          }

          IllegalStateException i = (IllegalStateException) e.getCause();

          return "Cursor has been closed".equals(i.getMessage());
        });
      }
      return this;
    }

    public MongoExceptionFilters ignoreMongoInterrupted(boolean ignore) {
      if (ignore) {
        ignoreList.add(MongoInterruptedException.class::isInstance);
      }
      return this;
    }

    public void check() {
      for (IfIgnore ifIgnore : ignoreList) {
        if (ifIgnore.ignore(error)) {
          return;
        }
      }
      throw error;
    }

  }

  public static MongoExceptionFilters mongo(MongoException error) {
    return new MongoExceptionFilters(error);
  }
}
