/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.spring.websocket.beans;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kz.greetgo.spring.websocket.controller.AnnotationFinder;
import kz.greetgo.spring.websocket.controller.ControllerManager;
import kz.greetgo.spring.websocket.controller.ExecuteInput;
import kz.greetgo.spring.websocket.controller.PreExecuteInterceptor;
import kz.greetgo.spring.websocket.interfaces.MessageSender;
import kz.greetgo.spring.websocket.interfaces.NeedClose;
import kz.greetgo.spring.websocket.interfaces.WebsocketController;
import kz.greetgo.spring.websocket.model.ToClient;
import kz.greetgo.spring.websocket.model.ToServer;
import kz.greetgo.spring.websocket.util.ConsoleColors;
import kz.greetgo.spring.websocket.util.LoggingUtil;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public abstract class AbstractWebSocketHandlerBean<UserSessionData extends NeedClose>
extends AbstractWebSocketHandler
implements InitializingBean,
PreExecuteInterceptor {
    private final ConcurrentHashMap<String, SessionData<UserSessionData>> sessionMap = new ConcurrentHashMap();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Logger callingLog = LoggingUtil.callingLog;
    private final ControllerManager controllerManager = new ControllerManager();
    @Autowired
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        this.controllerManager.setPreExecuteInterceptorSupplier(() -> this);
        Collection controllers = this.applicationContext.getBeansWithAnnotation(WebsocketController.class).values();
        for (Object controller : controllers) {
            this.controllerManager.registerController(controller);
        }
    }

    public void handleTransportError(@NonNull WebSocketSession session, @NonNull Throwable exception) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.log.error("0hbnSRlbME :: TransportError in " + session, exception);
    }

    public void afterConnectionEstablished(@NonNull WebSocketSession webSocketSession) {
        UserSessionData userData;
        SessionData oldSessionData;
        if (webSocketSession == null) {
            throw new NullPointerException("webSocketSession is marked non-null but is null");
        }
        SessionData sessionData = new SessionData(webSocketSession);
        if (callingLog.isInfoEnabled()) {
            callingLog.info(ConsoleColors.GREEN_BOLD() + "OPEN SESS " + ConsoleColors.RESET() + webSocketSession.getId());
        }
        if ((oldSessionData = this.sessionMap.put(webSocketSession.getId(), sessionData)) != null) {
            this.closeSession(webSocketSession.getId(), oldSessionData);
        }
        if ((userData = this.createUserDataOnNewSession(webSocketSession.getId())) != null) {
            sessionData.userData.set(userData);
        }
    }

    protected UserSessionData createUserDataOnNewSession(String sessionId) {
        return null;
    }

    private void closeSession(@NonNull String sessionId, @NonNull SessionData<UserSessionData> sessionData) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (sessionData == null) {
            throw new NullPointerException("sessionData is marked non-null but is null");
        }
        try {
            sessionData.webSocketSession.close();
            NeedClose userSessionData = (NeedClose)sessionData.userData.get();
            this.closeUserSessionData(sessionId, userSessionData);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected void closeUserSessionData(@NonNull String sessionId, UserSessionData userSessionData) throws Exception {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (userSessionData != null) {
            userSessionData.close();
        }
    }

    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus status) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        if (callingLog.isInfoEnabled()) {
            callingLog.info(ConsoleColors.RED_BOLD() + "CLOS SESS " + ConsoleColors.RESET() + session.getId() + " with status: " + status);
        }
        this.removeSessionById(session.getId());
    }

    protected void removeSessionById(String sessionId) {
        SessionData<UserSessionData> sessionData = this.sessionMap.remove(sessionId);
        if (sessionData != null) {
            this.closeSession(sessionId, sessionData);
        }
    }

    protected void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) throws Exception {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ToServer toServer = (ToServer)objectMapper.readValue((String)message.getPayload(), ToServer.class);
        ExecuteInput executeInput = ExecuteInput.builder().sessionIdSupplier(() -> ((WebSocketSession)session).getId()).setParams(toServer.params).build();
        if (callingLog.isInfoEnabled()) {
            callingLog.info(ConsoleColors.BLUE_BOLD() + "TO_SERVER" + ConsoleColors.RESET() + " " + session.getId() + " " + ConsoleColors.BLUE() + toServer.service + ConsoleColors.RESET() + " : " + toServer.params);
        }
        this.controllerManager.findAndExecuteService(toServer.service, executeInput);
    }

    public void sendToClient(@NonNull String sessionId, @NonNull ToClient toClient) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (toClient == null) {
            throw new NullPointerException("toClient is marked non-null but is null");
        }
        this.createMessageSender(sessionId).sendMessage(toClient);
    }

    @NonNull
    private SessionData<UserSessionData> sessionData(String sessionId) {
        SessionData<UserSessionData> sessionData = this.sessionMap.get(sessionId);
        if (sessionData == null) {
            throw new RuntimeException("77ioMM7DGw :: No session with id = " + sessionId);
        }
        return sessionData;
    }

    public String getToken(@NonNull String sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        return this.sessionData((String)sessionId).token.get();
    }

    public void setToken(@NonNull String sessionId, String value) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        this.sessionData((String)sessionId).token.set(value);
    }

    protected UserSessionData getUserSessionData(@NonNull String sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        SessionData<UserSessionData> sessionData = this.sessionMap.get(sessionId);
        if (sessionData == null) {
            throw new RuntimeException("KT6TIfC8j2 :: No session with id = " + sessionId);
        }
        return (UserSessionData)((NeedClose)sessionData.userData.get());
    }

    protected void setUserSessionData(@NonNull String sessionId, UserSessionData userSessionData) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        SessionData<UserSessionData> sessionData = this.sessionMap.get(sessionId);
        if (sessionData == null) {
            throw new RuntimeException("2p2euVyXsR :: No session with id = " + sessionId);
        }
        sessionData.userData.set(userSessionData);
    }

    @NonNull
    public MessageSender createMessageSender(@NonNull String sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        return toClient -> {
            try {
                WebSocketSession webSocketSession;
                ObjectMapper objectMapper = new ObjectMapper();
                SessionData<UserSessionData> sessionData = this.sessionData(sessionId);
                WebSocketSession webSocketSession2 = webSocketSession = sessionData.webSocketSession;
                synchronized (webSocketSession2) {
                    webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)objectMapper.writeValueAsString((Object)toClient)));
                }
                if (callingLog.isInfoEnabled()) {
                    callingLog.info(ConsoleColors.PURPLE_BOLD() + "TO_CLIENT" + ConsoleColors.RESET() + " " + sessionId + " " + ConsoleColors.PURPLE() + toClient.service + ConsoleColors.RESET() + " : " + toClient.body);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    public void preExecute(Object controller, Method method, String serviceFullName, ExecuteInput executeInput, AnnotationFinder annotationFinder) {
    }

    private static class SessionData<UserSessionData extends NeedClose> {
        final WebSocketSession webSocketSession;
        final AtomicReference<String> token = new AtomicReference();
        final AtomicReference<UserSessionData> userData = new AtomicReference();

        public SessionData(WebSocketSession webSocketSession) {
            this.webSocketSession = webSocketSession;
        }
    }
}

