/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.spring.websocket.controller;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kz.greetgo.spring.websocket.controller.ControllerParser;
import kz.greetgo.spring.websocket.controller.ExecuteInput;
import kz.greetgo.spring.websocket.controller.PreExecuteInterceptor;
import kz.greetgo.spring.websocket.interfaces.ServiceExecutor;
import kz.greetgo.spring.websocket.util.ConsoleColors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<String, ServiceExecutor> serviceExecutorMap = new ConcurrentHashMap();
    private Supplier<PreExecuteInterceptor> preExecuteInterceptorSupplier = () -> null;

    public void setPreExecuteInterceptorSupplier(@NonNull Supplier<PreExecuteInterceptor> preExecuteInterceptorSupplier) {
        this.preExecuteInterceptorSupplier = Objects.requireNonNull(preExecuteInterceptorSupplier);
    }

    public Object findAndExecuteService(String serviceName, ExecuteInput executeInput) {
        ServiceExecutor serviceExecutor = this.serviceExecutorMap.get(serviceName);
        if (serviceExecutor != null) {
            return serviceExecutor.execute(executeInput);
        }
        this.logger.error("XliQsOf6Ad :: No service with name " + serviceName);
        return null;
    }

    public void registerController(Object controller) {
        ControllerParser controllerParser = new ControllerParser();
        controllerParser.setPreExecuteInterceptorSupplier(this.preExecuteInterceptorSupplier);
        List<ServiceExecutor> serviceExecutorList = controllerParser.parse(controller);
        for (ServiceExecutor serviceExecutor : serviceExecutorList) {
            ServiceExecutor exists = this.serviceExecutorMap.get(serviceExecutor.serviceName());
            if (exists != null) {
                throw new RuntimeException("Cjk6xs4XvY :: You try to register two services with same name: " + serviceExecutor.serviceName() + "\n\tService 1 placed at " + exists.placeDisplayStr() + "\n\tService 2 placed at " + serviceExecutor.placeDisplayStr());
            }
            this.serviceExecutorMap.put(serviceExecutor.serviceName(), serviceExecutor);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info(ConsoleColors.PURPLE_BOLD() + "ws   controller" + ConsoleColors.RESET() + " " + ConsoleColors.BLUE() + serviceExecutor.serviceName() + ConsoleColors.RESET() + ConsoleColors.GREEN_BOLD() + " -> " + ConsoleColors.RESET() + ConsoleColors.BLACK_BOLD() + serviceExecutor.placeDisplayStr() + ConsoleColors.RESET());
        }
    }
}

