/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.spring.websocket.controller;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import kz.greetgo.spring.websocket.controller.AnnotationFinder;
import kz.greetgo.spring.websocket.controller.ExecuteInput;
import kz.greetgo.spring.websocket.controller.PreExecuteInterceptor;
import kz.greetgo.spring.websocket.exceptions.CannotCreateParamExtractor;
import kz.greetgo.spring.websocket.interfaces.Prm;
import kz.greetgo.spring.websocket.interfaces.ServiceExecutor;
import kz.greetgo.spring.websocket.interfaces.ServiceName;
import kz.greetgo.spring.websocket.interfaces.SessionId;
import kz.greetgo.spring.websocket.interfaces.WebsocketController;
import kz.greetgo.spring.websocket.util.MethodParamUtil;
import lombok.NonNull;
import org.springframework.core.annotation.AnnotationUtils;

public class ControllerParser {
    private Supplier<PreExecuteInterceptor> preExecuteInterceptor = () -> null;

    public void setPreExecuteInterceptorSupplier(@NonNull Supplier<PreExecuteInterceptor> preExecuteInterceptor) {
        this.preExecuteInterceptor = Objects.requireNonNull(preExecuteInterceptor);
    }

    public List<ServiceExecutor> parse(Object controller) {
        WebsocketController websocketController = (WebsocketController)AnnotationUtils.findAnnotation(controller.getClass(), WebsocketController.class);
        if (websocketController == null) {
            return Collections.emptyList();
        }
        ArrayList<ServiceExecutor> ret = new ArrayList<ServiceExecutor>();
        for (Method method : controller.getClass().getMethods()) {
            ServiceName serviceName = (ServiceName)AnnotationUtils.findAnnotation((Method)method, ServiceName.class);
            if (serviceName == null) continue;
            String serviceFullName = websocketController.value() + "/" + serviceName.value();
            ret.add(this.createExecutorOn(controller, method, serviceFullName));
        }
        return Collections.unmodifiableList(ret);
    }

    private ServiceExecutor createExecutorOn(final Object controller, final Method method, final String serviceFullName) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = MethodParamUtil.getAllParameterAnnotations(method);
        final int parameterCount = method.getParameterCount();
        final ParamExtractor[] paramExtractors = new ParamExtractor[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            paramExtractors[i] = this.createParamExtractor(parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i], method);
        }
        final Class<?> controllerClass = controller.getClass();
        final AnnotationFinder annotationFinder = new AnnotationFinder(){

            @Override
            public <A extends Annotation> A find(Class<A> annotationType, boolean findOverMethod, boolean findOverControllerClass) {
                Annotation annotation;
                if (annotationType == null) {
                    return null;
                }
                if (findOverMethod && (annotation = AnnotationUtils.findAnnotation((Method)method, annotationType)) != null) {
                    return (A)annotation;
                }
                if (findOverControllerClass && (annotation = AnnotationUtils.findAnnotation((Class)controllerClass, annotationType)) != null) {
                    return (A)annotation;
                }
                return null;
            }
        };
        return new ServiceExecutor(){

            @Override
            public String serviceName() {
                return serviceFullName;
            }

            @Override
            public String placeDisplayStr() {
                String simpleName = controller.getClass().getSimpleName();
                int idx = simpleName.indexOf("$$");
                if (idx >= 0) {
                    simpleName = simpleName.substring(0, idx);
                }
                return simpleName + "." + method.getName() + "()";
            }

            @Override
            public Object execute(ExecuteInput executeInput) {
                PreExecuteInterceptor x = ControllerParser.this.preExecuteInterceptor.get();
                if (x != null) {
                    x.preExecute(controller, method, serviceFullName, executeInput, annotationFinder);
                }
                Object[] paramValues = new Object[parameterCount];
                for (int i = 0; i < parameterCount; ++i) {
                    paramValues[i] = paramExtractors[i].extract(executeInput);
                }
                try {
                    return method.invoke(controller, paramValues);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException("I68J6ww2H8 :: error in controller " + this.placeDisplayStr(), cause);
                }
            }
        };
    }

    private ParamExtractor createParamExtractor(Class<?> parameterType, Type genericParameterType, @NonNull Annotation[] parameterAnnotations, Method method) {
        if (parameterAnnotations == null) {
            throw new NullPointerException("parameterAnnotations is marked non-null but is null");
        }
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (parameterAnnotation instanceof SessionId) {
                return executeSource -> executeSource.sessionIdSupplier.get();
            }
            if (!(parameterAnnotation instanceof Prm)) continue;
            String prmName = ((Prm)parameterAnnotation).value();
            return executeSource -> executeSource.getParamConvertedToType(prmName, parameterType, genericParameterType);
        }
        throw new CannotCreateParamExtractor(parameterType, genericParameterType, parameterAnnotations, method);
    }

    static interface ParamExtractor {
        public Object extract(ExecuteInput var1);
    }
}

