/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.spring.websocket.controller;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import kz.greetgo.spring.websocket.util.ConvertUtil;
import lombok.NonNull;

public class ExecuteInput {
    @NonNull
    public final Supplier<String> sessionIdSupplier;
    public final Map<String, Object> params;
    private static final Supplier<String> RETURNS_NULL = () -> null;

    private ExecuteInput(@NonNull Supplier<String> sessionIdSupplier, Map<String, Object> params) {
        if (sessionIdSupplier == null) {
            throw new NullPointerException("sessionIdSupplier is marked non-null but is null");
        }
        this.sessionIdSupplier = sessionIdSupplier;
        this.params = params;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Object getParamValue(String prmName) {
        return this.params.get(prmName);
    }

    public Object getParamConvertedToType(String prmName, Class<?> parameterType, Type genericParameterType) {
        return ConvertUtil.convertToType(this.getParamValue(prmName), parameterType, genericParameterType);
    }

    public static class Builder {
        private final Map<String, Object> params = new HashMap<String, Object>();
        private Supplier<String> sessionIdSupplier = RETURNS_NULL;

        private Builder() {
        }

        public Builder setParams(Map<String, Object> params) {
            this.params.clear();
            if (params != null) {
                this.params.putAll(params);
            }
            return this;
        }

        public Builder param(String key, Object value) {
            this.params.put(key, value);
            return this;
        }

        public Builder sessionIdSupplier(Supplier<String> sessionIdSupplier) {
            this.sessionIdSupplier = Objects.requireNonNullElse(sessionIdSupplier, RETURNS_NULL);
            return this;
        }

        @NonNull
        public ExecuteInput build() {
            return new ExecuteInput(this.sessionIdSupplier, Collections.unmodifiableMap(this.params));
        }
    }
}

