/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.util.fui;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kz.greetgo.util.fui.BoolAccessor;
import kz.greetgo.util.fui.ButtonClickHandler;
import kz.greetgo.util.fui.ChangeHandler;
import kz.greetgo.util.fui.IntAccessor;
import kz.greetgo.util.fui.Pingable;
import kz.greetgo.util.fui.PingableList;
import kz.greetgo.util.fui.SliceButton;
import kz.greetgo.util.fui.StrAccessor;

public class FUI {
    private final Path baseDir;
    private final Path closeFile;
    private final PingableList pingableList = new PingableList();

    public FUI(Path baseDir) {
        this.baseDir = baseDir;
        this.closeFile = baseDir.resolve("shutdown-application.btn");
    }

    public void go() {
        this.closeFile.toFile().getParentFile().mkdirs();
        this.closeFile.toFile().createNewFile();
        while (this.closeFile.toFile().exists()) {
            this.pingableList.list().forEach(Pingable::ping);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void button(final String buttonName, final ButtonClickHandler buttonClickHandler) {
        final File file = this.baseDir.resolve(buttonName + ".btn").toFile();
        file.getParentFile().mkdirs();
        file.createNewFile();
        this.pingableList.add(new Pingable(){

            @Override
            public void ping() {
                if (file.exists()) {
                    return;
                }
                file.createNewFile();
                System.out.println("mvx3J4MZqK :: Button " + buttonName + " clicked...");
                buttonClickHandler.clicked();
            }
        });
    }

    public SliceButton sliceButton(String buttonName) {
        final File file = this.baseDir.resolve(buttonName + ".btn").toFile();
        file.getParentFile().mkdirs();
        file.createNewFile();
        return new SliceButton(){
            final AtomicReference<Long> prevCheckExists = new AtomicReference<Object>(null);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isClicked() {
                long delta;
                Long prevCheck = this.prevCheckExists.get();
                long now = System.currentTimeMillis();
                if (prevCheck != null && (delta = now - prevCheck) <= 300L) {
                    return false;
                }
                try {
                    if (file.exists()) {
                        boolean bl = false;
                        return bl;
                    }
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.prevCheckExists.set(now);
                }
            }
        };
    }

    public StrAccessor entryStr(String entryName, String defaultValue, ChangeHandler changeHandler) {
        return this.entryStr0(entryName, ".entryStr", defaultValue, changeHandler);
    }

    public IntAccessor entryInt(String entryName, Integer defaultValue, ChangeHandler changeHandler) {
        final StrAccessor a = this.entryStr0(entryName, ".entryInt", defaultValue == null ? null : "" + defaultValue, changeHandler);
        return new IntAccessor(){

            @Override
            public Integer get() {
                String str = a.get();
                return str == null ? null : Integer.valueOf(str.trim());
            }

            @Override
            public int getInt() {
                Integer x = this.get();
                return x == null ? 0 : x;
            }

            @Override
            public void set(Integer value) {
                a.set(value == null ? null : "" + value);
            }
        };
    }

    public IntAccessor entryInt(String entryName, Integer defaultValue) {
        return this.entryInt(entryName, defaultValue, null);
    }

    private StrAccessor entryStr0(final String entryName, String extension, String defaultValue, final ChangeHandler changeHandler) {
        Path entryFile = this.baseDir.resolve(entryName + extension);
        final File fileSet = entryFile.resolve("set").toFile();
        final Path fileValue = entryFile.resolve("value");
        fileSet.getParentFile().mkdirs();
        fileSet.createNewFile();
        final AtomicReference<String> valueRef = new AtomicReference<String>();
        StrAccessor ret = new StrAccessor(){

            @Override
            public String get() {
                return (String)valueRef.get();
            }

            @Override
            public void set(String value) {
                valueRef.set(value);
                if (value == null) {
                    Files.delete(fileValue);
                    return;
                }
                fileValue.toFile().getParentFile().mkdirs();
                Files.writeString(fileValue, (CharSequence)value, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        };
        if (fileValue.toFile().exists()) {
            valueRef.set(Files.readString(fileValue));
        } else {
            ret.set(defaultValue);
        }
        this.pingableList.add(new Pingable(){

            @Override
            public void ping() {
                if (fileSet.exists()) {
                    return;
                }
                fileSet.getParentFile().mkdirs();
                fileSet.createNewFile();
                if (fileValue.toFile().exists()) {
                    valueRef.set(Files.readString(fileValue, StandardCharsets.UTF_8));
                } else {
                    valueRef.set(null);
                }
                System.out.println("rykT6zW363 :: Entry " + entryName + " = " + (String)valueRef.get());
                if (changeHandler != null) {
                    changeHandler.changed();
                }
            }
        });
        System.out.println("kZka13ZZl7 :: Entry " + entryName + " = " + FUI.trim((String)valueRef.get()));
        return ret;
    }

    private static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public BoolAccessor entryBool(String entryName, boolean defaultValue, final ChangeHandler changeHandler) {
        final Path fileTrue = this.baseDir.resolve(entryName + "-true");
        final Path fileFalse = this.baseDir.resolve(entryName + "-false");
        final AtomicBoolean valueRef = new AtomicBoolean();
        final Consumer<Boolean> write = new Consumer<Boolean>(){

            @Override
            public void accept(Boolean value) {
                File toDel;
                File toCreate;
                boolean flag;
                boolean bl = flag = value == null ? false : value;
                if (flag) {
                    toCreate = fileTrue.toFile();
                    toDel = fileFalse.toFile();
                } else {
                    toDel = fileTrue.toFile();
                    toCreate = fileFalse.toFile();
                }
                toDel.delete();
                toCreate.getParentFile().mkdirs();
                toCreate.createNewFile();
            }
        };
        BooleanSupplier read = () -> {
            boolean existsTrue = Files.exists(fileTrue, new LinkOption[0]);
            boolean existsFalse = Files.exists(fileFalse, new LinkOption[0]);
            if (existsTrue && existsFalse || !existsTrue && !existsFalse) {
                write.accept(defaultValue);
                return defaultValue;
            }
            return existsTrue;
        };
        valueRef.set(read.getAsBoolean());
        System.out.println("uAy2Snl8Ya :: " + entryName + " started with " + valueRef.get());
        final Object sync = new Object();
        this.pingableList.add(() -> {
            boolean existsTrue = Files.exists(fileTrue, new LinkOption[0]);
            boolean existsFalse = Files.exists(fileFalse, new LinkOption[0]);
            if (existsTrue || existsFalse) {
                return;
            }
            Object object = sync;
            synchronized (object) {
                boolean newValue = !valueRef.get();
                valueRef.set(newValue);
                write.accept(newValue);
            }
            System.out.println("uAy2Snl8Ya :: " + entryName + " changed to " + valueRef.get());
            changeHandler.changed();
        });
        return new BoolAccessor(){

            @Override
            public boolean is() {
                return valueRef.get();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(boolean flag) {
                Object object = sync;
                synchronized (object) {
                    boolean oldFlag = valueRef.getAndSet(flag);
                    if (oldFlag == flag) {
                        return;
                    }
                    write.accept(flag);
                }
                if (changeHandler != null) {
                    changeHandler.changed();
                }
            }
        };
    }
}

