/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.util.fui;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.logging.Logger;
import kz.greetgo.util.fui.BoolAccessor;
import kz.greetgo.util.fui.IntAccessor;
import kz.greetgo.util.fui.Pingable;
import kz.greetgo.util.fui.PingableList;
import kz.greetgo.util.fui.SliceButton;
import kz.greetgo.util.fui.StrAccessor;
import kz.greetgo.util.fui.handler.BoolChangeHandler;
import kz.greetgo.util.fui.handler.BoolChangeHandlerList;
import kz.greetgo.util.fui.handler.ButtonClickHandler;
import kz.greetgo.util.fui.handler.ButtonClickHandlerList;
import kz.greetgo.util.fui.handler.HandlerAttaching;
import kz.greetgo.util.fui.handler.HandlerDetaching;
import kz.greetgo.util.fui.handler.IntChangeHandler;
import kz.greetgo.util.fui.handler.IntChangeHandlerList;
import kz.greetgo.util.fui.handler.StrChangeHandler;
import kz.greetgo.util.fui.handler.StrChangeHandlerList;
import kz.greetgo.util.fui.handler.ThrowAcceptor;

public class FUI {
    private static final Logger log = Logger.getLogger(FUI.class.getName());
    private final Path baseDir;
    private final Path closeFile;
    private final AtomicInteger pingSleep = new AtomicInteger(500);
    private final AtomicBoolean appIsWorking = new AtomicBoolean(true);
    private final PingableList pingableList = new PingableList();
    private final AtomicReference<ThrowAcceptor> throwAcceptor = new AtomicReference<ThrowAcceptor>(Throwable::printStackTrace);
    public final AtomicBoolean logComponentEvents = new AtomicBoolean(false);

    public int getPingSleep() {
        return this.pingSleep.get();
    }

    public void setPingSleep(int pingSleep) {
        this.pingSleep.set(pingSleep);
    }

    public FUI(Path baseDir) {
        this.baseDir = baseDir;
        this.closeFile = baseDir.resolve("shutdown-application.btn");
    }

    public void setThrowAcceptor(ThrowAcceptor throwAcceptor) {
        this.throwAcceptor.set(throwAcceptor != null ? throwAcceptor : Throwable::printStackTrace);
    }

    private void acceptThrow(Throwable e) {
        this.throwAcceptor.get().accept(e);
    }

    public boolean isAlive() {
        return this.appIsWorking.get();
    }

    public void go() {
        this.closeFile.toFile().getParentFile().mkdirs();
        this.closeFile.toFile().createNewFile();
        while (this.appIsWorking.get() && this.closeFile.toFile().exists()) {
            this.pingableList.list().forEach(Pingable::ping);
            try {
                Thread.sleep(this.pingSleep.get());
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void shutdown() {
        this.appIsWorking.set(false);
    }

    public HandlerAttaching<ButtonClickHandler> button(final String buttonName, ButtonClickHandler buttonClickHandler) {
        final File file = this.baseDir.resolve(buttonName + ".btn").toFile();
        file.getParentFile().mkdirs();
        file.createNewFile();
        final ButtonClickHandlerList handlerList = new ButtonClickHandlerList(this::acceptThrow);
        handlerList.attach(buttonClickHandler);
        this.pingableList.add(new Pingable(){

            @Override
            public void ping() {
                if (file.exists()) {
                    return;
                }
                file.getParentFile().mkdirs();
                file.createNewFile();
                if (FUI.this.logComponentEvents.get()) {
                    log.info(() -> "mvx3J4MZqK :: Button " + buttonName + " clicked...");
                }
                handlerList.fire();
            }
        });
        return handlerList;
    }

    public HandlerAttaching<ButtonClickHandler> button(String buttonName) {
        return this.button(buttonName, null);
    }

    public StrAccessor entryStr(String entryName, String defaultValue, StrChangeHandler changeHandler) {
        return this.entryStr0(entryName, ".entryStr", defaultValue, changeHandler);
    }

    public StrAccessor entryStr(String entryName, String defaultValue) {
        return this.entryStr0(entryName, ".entryStr", defaultValue, null);
    }

    public IntAccessor entryInt(String entryName, Integer defaultValue, IntChangeHandler changeHandler) {
        final IntChangeHandlerList handlerList = new IntChangeHandlerList(this::acceptThrow);
        handlerList.attach(changeHandler);
        final StrAccessor a = this.entryStr0(entryName, ".entryInt", defaultValue == null ? null : "" + defaultValue, handlerList.strChangeHandler);
        return new IntAccessor(){

            @Override
            public Integer get() {
                String str = a.get();
                return str == null ? null : Integer.valueOf(str.trim());
            }

            @Override
            public int getInt() {
                Integer x = this.get();
                return x == null ? 0 : x;
            }

            @Override
            public void set(Integer value) {
                a.set(value == null ? null : "" + value);
            }

            @Override
            public HandlerDetaching attachChangeHandler(IntChangeHandler handler) {
                return handlerList.attach(handler);
            }
        };
    }

    public IntAccessor entryInt(String entryName, Integer defaultValue) {
        return this.entryInt(entryName, defaultValue, null);
    }

    private StrAccessor entryStr0(final String entryName, String extension, String defaultValue, StrChangeHandler changeHandler) {
        Path entryFile = this.baseDir.resolve(entryName + extension);
        final File fileSet = entryFile.resolve("set").toFile();
        final Path fileValue = entryFile.resolve("value");
        fileSet.getParentFile().mkdirs();
        fileSet.createNewFile();
        final AtomicReference<String> valueRef = new AtomicReference<String>();
        final StrChangeHandlerList handlerList = new StrChangeHandlerList(this::acceptThrow);
        handlerList.attach(changeHandler);
        StrAccessor ret = new StrAccessor(){

            @Override
            public String get() {
                return (String)valueRef.get();
            }

            @Override
            public void set(String value) {
                valueRef.set(value);
                if (value == null) {
                    Files.delete(fileValue);
                    return;
                }
                fileValue.toFile().getParentFile().mkdirs();
                Files.writeString(fileValue, (CharSequence)value, StandardCharsets.UTF_8, new OpenOption[0]);
            }

            @Override
            public HandlerDetaching attach(StrChangeHandler strChangeHandler) {
                return handlerList.attach(strChangeHandler);
            }
        };
        if (fileValue.toFile().exists()) {
            valueRef.set(Files.readString(fileValue));
        } else {
            ret.set(defaultValue);
        }
        this.pingableList.add(new Pingable(){

            @Override
            public void ping() {
                if (fileSet.exists()) {
                    return;
                }
                fileSet.getParentFile().mkdirs();
                fileSet.createNewFile();
                String newValue = fileValue.toFile().exists() ? Files.readString(fileValue, StandardCharsets.UTF_8) : null;
                valueRef.set(newValue);
                if (FUI.this.logComponentEvents.get()) {
                    log.info(() -> "rykT6zW363 :: Entry " + entryName + " = " + newValue);
                }
                handlerList.fire(newValue);
            }
        });
        if (this.logComponentEvents.get()) {
            log.info(() -> "kZka13ZZl7 :: Entry " + entryName + " = " + FUI.trim((String)valueRef.get()));
        }
        return ret;
    }

    private static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public BoolAccessor entryBool(String entryName, boolean defaultValue) {
        return this.entryBool(entryName, defaultValue, null);
    }

    public BoolAccessor entryBool(String entryName, boolean defaultValue, BoolChangeHandler changeHandler) {
        final Path fileTrue = this.baseDir.resolve(entryName + "-true");
        final Path fileFalse = this.baseDir.resolve(entryName + "-false");
        final AtomicBoolean valueRef = new AtomicBoolean();
        final Consumer<Boolean> write = new Consumer<Boolean>(){

            @Override
            public void accept(Boolean value) {
                File toDel;
                File toCreate;
                boolean flag;
                boolean bl = flag = value == null ? false : value;
                if (flag) {
                    toCreate = fileTrue.toFile();
                    toDel = fileFalse.toFile();
                } else {
                    toDel = fileTrue.toFile();
                    toCreate = fileFalse.toFile();
                }
                toDel.delete();
                toCreate.getParentFile().mkdirs();
                toCreate.createNewFile();
            }
        };
        BooleanSupplier read = () -> {
            boolean existsTrue = Files.exists(fileTrue, new LinkOption[0]);
            boolean existsFalse = Files.exists(fileFalse, new LinkOption[0]);
            if (existsTrue && existsFalse || !existsTrue && !existsFalse) {
                write.accept(defaultValue);
                return defaultValue;
            }
            return existsTrue;
        };
        valueRef.set(read.getAsBoolean());
        if (this.logComponentEvents.get()) {
            log.info(() -> "uAy2Snl8Ya :: " + entryName + " started with " + valueRef.get());
        }
        final Object sync = new Object();
        final BoolChangeHandlerList handlerList = new BoolChangeHandlerList(this::acceptThrow);
        handlerList.attach(changeHandler);
        this.pingableList.add(() -> {
            boolean newValue;
            boolean existsTrue = Files.exists(fileTrue, new LinkOption[0]);
            boolean existsFalse = Files.exists(fileFalse, new LinkOption[0]);
            if (existsTrue || existsFalse) {
                return;
            }
            Object object = sync;
            synchronized (object) {
                newValue = !valueRef.get();
                valueRef.set(newValue);
                write.accept(newValue);
            }
            if (this.logComponentEvents.get()) {
                log.info(() -> "uAy2Snl8Ya :: " + entryName + " changed to " + valueRef.get());
            }
            handlerList.fire(newValue);
        });
        return new BoolAccessor(){

            @Override
            public boolean is() {
                return valueRef.get();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(boolean flag) {
                Object object = sync;
                synchronized (object) {
                    boolean oldFlag = valueRef.getAndSet(flag);
                    if (oldFlag == flag) {
                        return;
                    }
                    write.accept(flag);
                }
            }

            @Override
            public HandlerDetaching attachChangeHandler(BoolChangeHandler handler) {
                return handlerList.attach(handler);
            }
        };
    }

    public SliceButton sliceButton(String buttonName) {
        final File file = this.baseDir.resolve(buttonName + ".btn").toFile();
        file.getParentFile().mkdirs();
        file.createNewFile();
        return new SliceButton(){
            final AtomicReference<Long> prevCheckExists = new AtomicReference<Object>(null);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isClicked() {
                long delta;
                Long prevCheck = this.prevCheckExists.get();
                long now = System.currentTimeMillis();
                if (prevCheck != null && (delta = now - prevCheck) <= 300L) {
                    return false;
                }
                try {
                    if (file.exists()) {
                        boolean bl = false;
                        return bl;
                    }
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.prevCheckExists.set(now);
                }
            }
        };
    }
}

