/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;

public class ServerUtil {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static String firstUpper(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    @SafeVarargs
    public static <T> T fnn(T ... tt) {
        for (T t : tt) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static void dummyCheck(boolean tmp) {
    }

    public static <T> T notNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static void appendToSB(InputStream in, StringBuilder sb) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ServerUtil.copyStreamsAndCloseIn(in, bout);
        sb.append(new String(bout.toByteArray(), StandardCharsets.UTF_8));
    }

    public static byte[] streamToByteArray(InputStream in) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ServerUtil.copyStreamsAndCloseIn(in, bout);
        return bout.toByteArray();
    }

    public static String streamToStr(InputStream in) {
        StringBuilder sb = new StringBuilder();
        ServerUtil.appendToSB(in, sb);
        return sb.toString();
    }

    public static String readFile(File file) {
        try {
            return ServerUtil.streamToStr(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OutputStream copyStreamsAndCloseIn(InputStream in, OutputStream out) {
        try {
            int read;
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) >= 0) {
                out.write(buffer, 0, read);
            }
            OutputStream outputStream = out;
            return outputStream;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void justOne(int value) {
        if (value == 1) {
            return;
        }
        throw new IllegalArgumentException("Update count = " + value);
    }

    public static String extractPackage(String className) {
        int idx = className.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        return className.substring(0, idx);
    }

    public static File resolveFile(String srcDir, String className, String extension) {
        return new File(srcDir + "/" + className.replace('.', '/') + (extension == null ? ".java" : extension));
    }

    public static String extractName(String className) {
        int idx = className.lastIndexOf(46);
        if (idx < 0) {
            return className;
        }
        return className.substring(idx + 1);
    }

    public static void deleteRecursively(File file) {
        File[] subFiles;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (subFiles = file.listFiles()) != null) {
            for (File subFile : subFiles) {
                ServerUtil.deleteRecursively(subFile);
            }
        }
        ServerUtil.dummyCheck(file.delete());
    }

    public static void deleteRecursively(String fileFullName) {
        ServerUtil.deleteRecursively(new File(fileFullName));
    }

    public static byte[] javaSerialize(Object object) {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bout);){
            oos.writeObject(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bout.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T javaDeserialize(byte[] bytes) {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        try (ObjectInputStream oin = new ObjectInputStream(bin);){
            Object object = oin.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static String trimLeft(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            if (i == 0) {
                return str;
            }
            return str.substring(i);
        }
        return "";
    }

    public static String trimRight(String str) {
        if (str == null) {
            return null;
        }
        int i = str.length() - 1;
        if (str.charAt(i) > ' ') {
            return str;
        }
        while (i >= 0) {
            if (str.charAt(i) > ' ') {
                return str.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotation) {
        T ann;
        while ((ann = method.getAnnotation(annotation)) == null) {
            Class<?> aClass = method.getDeclaringClass();
            if (aClass == Object.class) {
                return null;
            }
            Class<?> superclass = aClass.getSuperclass();
            try {
                method = superclass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return ann;
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

