/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.xml.dom.impl;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kz.greetgo.xml.dom.XmlTag;
import kz.greetgo.xml.error.ParseXmlError;
import kz.greetgo.xml.error.ParseXmlNull;
import lombok.NonNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlTagImpl
implements XmlTag {
    private final Document document;
    private final Element tag;
    private final Map<String, String> namespaceUriToPrefix = new HashMap<String, String>();
    private final Map<String, String> namespacePrefixToUri = new HashMap<String, String>();

    public XmlTagImpl(@NonNull Document document, @NonNull Element tag) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.document = document;
        this.tag = tag;
    }

    public XmlTagImpl(@NonNull XmlTagImpl bro, @NonNull Element tag) {
        if (bro == null) {
            throw new NullPointerException("bro is marked non-null but is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.document = bro.document;
        this.tag = tag;
        this.copyNamespaceAliasesFrom(bro);
    }

    @Override
    public Map<String, String> namespaceUriToPrefix() {
        return Map.copyOf(this.namespaceUriToPrefix);
    }

    private static DocumentBuilder newDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    @NonNull
    public static XmlTagImpl parseXmlText(String xmlText) {
        if (xmlText == null) {
            throw new ParseXmlNull();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringReader stringReader = new StringReader(xmlText);
        InputSource inputSource = new InputSource(stringReader);
        try {
            Document document = builder.parse(inputSource);
            return new XmlTagImpl(document, document.getDocumentElement());
        }
        catch (Exception e) {
            throw new ParseXmlError(e);
        }
    }

    @NonNull
    public static XmlTagImpl root(String namespaceUri, @NonNull String qName) {
        if (qName == null) {
            throw new NullPointerException("qName is marked non-null but is null");
        }
        DocumentBuilder builder = XmlTagImpl.newDocumentBuilder();
        Document document = builder.newDocument();
        int idx = qName.indexOf(":");
        if (idx < 0) {
            Element rootElement = document.createElement(qName);
            document.appendChild(rootElement);
            return new XmlTagImpl(document, rootElement);
        }
        Element rootElement = document.createElementNS(namespaceUri, qName);
        document.appendChild(rootElement);
        XmlTagImpl ret = new XmlTagImpl(document, rootElement);
        ret.addNamespacePrefix(namespaceUri, qName.substring(0, idx));
        return ret;
    }

    @Override
    public String outerXml() {
        return this.convertToStr(false);
    }

    @Override
    public String outerXmlPretty() {
        return this.convertToStr(true);
    }

    private String convertToStr(boolean pretty) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource domSource = new DOMSource(this.tag);
        StringWriter outString = new StringWriter();
        StreamResult result = new StreamResult(outString);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        if (pretty) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        transformer.transform(domSource, result);
        return outString.toString();
    }

    @Override
    public void addNamespacePrefix(String namespaceUri, String alias) {
        this.namespaceUriToPrefix.put(namespaceUri, alias);
        this.namespacePrefixToUri.put(alias, namespaceUri);
    }

    @Override
    public XmlTagImpl gotoTag(String qNamePath) {
        if (qNamePath == null) {
            return this;
        }
        Element current = this.tag;
        if (qNamePath.startsWith("/")) {
            current = this.document.getDocumentElement();
            qNamePath = qNamePath.substring(1);
        }
        for (String qName : qNamePath.split("/")) {
            current = this.selectChildOrCreate(current, qName);
        }
        return new XmlTagImpl(this, current);
    }

    private void copyNamespaceAliasesFrom(@NonNull XmlTagImpl other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.namespacePrefixToUri.putAll(other.namespacePrefixToUri);
        this.namespaceUriToPrefix.putAll(other.namespaceUriToPrefix);
    }

    private TagName parseQName(@NonNull String qName) {
        if (qName == null) {
            throw new NullPointerException("qName is marked non-null but is null");
        }
        int idx = qName.indexOf(":");
        if (idx < 0) {
            return new TagName(null, qName);
        }
        String namespaceAlias = qName.substring(0, idx);
        String localName = qName.substring(idx + 1);
        String uri = this.namespacePrefixToUri.get(namespaceAlias);
        if (uri != null) {
            return new TagName(uri, localName);
        }
        String namespaceUri = this.document.lookupNamespaceURI(namespaceAlias);
        if (namespaceUri != null) {
            return new TagName(namespaceUri, localName);
        }
        return new TagName(null, localName);
    }

    @NonNull
    private Element selectChildOrCreate(@NonNull Element current, @NonNull String qName) {
        if (current == null) {
            throw new NullPointerException("current is marked non-null but is null");
        }
        if (qName == null) {
            throw new NullPointerException("qName is marked non-null but is null");
        }
        TagName childName = this.parseQName(qName);
        NodeList childNodes = current.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Element child;
            Node item = childNodes.item(i);
            if (!(item instanceof Element) || !childName.eq(child = (Element)item)) continue;
            return child;
        }
        Element child = childName.create();
        current.appendChild(child);
        return child;
    }

    @Override
    public String getInnerText() {
        return this.tag.getTextContent();
    }

    @Override
    public XmlTagImpl setInnerText(String innerText) {
        this.tag.setTextContent(innerText);
        return this;
    }

    @Override
    public XmlTagImpl append(@NonNull XmlTag anotherTag) {
        if (anotherTag == null) {
            throw new NullPointerException("anotherTag is marked non-null but is null");
        }
        if (!(anotherTag instanceof XmlTagImpl)) {
            throw new RuntimeException("1GBO6ab1ot :: Illegal argument class");
        }
        XmlTagImpl x = (XmlTagImpl)anotherTag;
        this.tag.appendChild(this.document.importNode(x.tag, true));
        return this;
    }

    @Override
    public XmlTagImpl appendNewTag(@NonNull String tagName) {
        if (tagName == null) {
            throw new NullPointerException("tagName is marked non-null but is null");
        }
        Element newElement = this.findNamespace(tagName).map(x -> this.document.createElementNS(x.namespaceUri, tagName)).orElseGet(() -> this.document.createElement(tagName));
        this.tag.appendChild(newElement);
        return new XmlTagImpl(this, newElement);
    }

    @NonNull
    private Optional<NsName> findNamespace(@NonNull String tagName) {
        if (tagName == null) {
            throw new NullPointerException("tagName is marked non-null but is null");
        }
        int idx = tagName.indexOf(":");
        if (idx < 0) {
            return Optional.empty();
        }
        String prefix = tagName.substring(0, idx);
        String localName = tagName.substring(idx + 1);
        String namespaceUri = this.namespacePrefixToUri.get(prefix);
        if (namespaceUri != null) {
            return Optional.of(new NsName(namespaceUri, localName, prefix));
        }
        String namespaceURI = this.tag.lookupNamespaceURI(prefix);
        if (namespaceURI != null) {
            return Optional.of(new NsName(namespaceURI, localName, prefix));
        }
        throw new RuntimeException("4512QLc1sg :: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u043e \u0438\u043c\u0451\u043d \u0434\u043b\u044f " + prefix);
    }

    @Override
    public XmlTagImpl setAttribute(@NonNull String attrName, String attrValue) {
        if (attrName == null) {
            throw new NullPointerException("attrName is marked non-null but is null");
        }
        this.findNamespace(attrName).ifPresentOrElse(x -> this.tag.setAttributeNS(x.namespaceUri, attrName, attrValue), () -> this.tag.setAttribute(attrName, attrValue));
        return this;
    }

    @Override
    public XmlTag removeAttribute(String attrName) {
        this.findNamespace(attrName).ifPresentOrElse(x -> this.tag.removeAttributeNS(x.namespaceUri, x.localName), () -> this.tag.removeAttribute(attrName));
        this.document.normalizeDocument();
        return this;
    }

    @Override
    public List<XmlTag> children() {
        NodeList children = this.tag.getChildNodes();
        ArrayList<XmlTag> ret = new ArrayList<XmlTag>();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node item = children.item(i);
            if (!(item instanceof Element)) continue;
            Element e = (Element)item;
            ret.add(new XmlTagImpl(this, e));
        }
        return ret;
    }

    private class TagName {
        final String namespaceUri;
        final String localName;

        boolean eq(Element element) {
            return Objects.equals(this.namespaceUri, element.getNamespaceURI()) && Objects.equals(this.localName, element.getLocalName());
        }

        Element create() {
            if (this.namespaceUri == null) {
                return XmlTagImpl.this.document.createElement(this.localName);
            }
            String alias = XmlTagImpl.this.namespaceUriToPrefix.get(this.namespaceUri);
            if (alias != null) {
                return XmlTagImpl.this.document.createElementNS(this.namespaceUri, alias + ":" + this.localName);
            }
            return XmlTagImpl.this.document.createElementNS(this.namespaceUri, this.localName);
        }

        public String toString() {
            return "XmlTagImpl.TagName(namespaceUri=" + this.namespaceUri + ", localName=" + this.localName + ")";
        }

        public TagName(String namespaceUri, String localName) {
            this.namespaceUri = namespaceUri;
            this.localName = localName;
        }
    }

    private static class NsName {
        @NonNull
        final String namespaceUri;
        @NonNull
        final String localName;
        @NonNull
        final String prefix;

        public NsName(@NonNull String namespaceUri, @NonNull String localName, @NonNull String prefix) {
            if (namespaceUri == null) {
                throw new NullPointerException("namespaceUri is marked non-null but is null");
            }
            if (localName == null) {
                throw new NullPointerException("localName is marked non-null but is null");
            }
            if (prefix == null) {
                throw new NullPointerException("prefix is marked non-null but is null");
            }
            this.namespaceUri = namespaceUri;
            this.localName = localName;
            this.prefix = prefix;
        }
    }
}

