/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.xml.sax;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import lombok.NonNull;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SaxHandler
extends DefaultHandler {
    private final Map<String, String> namespaceUriToUserAlias = new HashMap<String, String>();
    private final List<String> pathList = new ArrayList<String>();
    private StringBuilder text = null;

    @NonNull
    protected static <Handler extends SaxHandler> Handler parse(@NonNull Handler handler, @NonNull String xmlText) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        if (xmlText == null) {
            throw new NullPointerException("xmlText is marked non-null but is null");
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            InputSource inputSource = new InputSource(new StringReader(xmlText));
            saxParser.parse(inputSource, handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("yUCn9AP7Qs :: SAX parse error", e);
        }
        return handler;
    }

    @NonNull
    protected final String tagPath() {
        return "/" + String.join((CharSequence)"/", this.pathList);
    }

    protected final String text() {
        StringBuilder s = this.text;
        return s == null ? "" : s.toString();
    }

    protected Map<String, String> collectNamespacesToUserAlias() {
        return Map.of();
    }

    @Override
    public final void startDocument() throws SAXException {
        this.namespaceUriToUserAlias.putAll(this.collectNamespacesToUserAlias());
        try {
            this.startDoc();
        }
        catch (RuntimeException | SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void startDoc() throws Exception {
    }

    private String extractName(String uri, String localName, String qName) {
        if (uri == null || uri.isBlank()) {
            return localName;
        }
        String userAlias = this.namespaceUriToUserAlias.get(uri);
        if (userAlias == null) {
            return qName;
        }
        return userAlias + ":" + localName;
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.pathList.add(this.extractName(uri, localName, qName));
        this.text = null;
        try {
            this.startTag(attributes);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void startTag(Attributes var1) throws Exception;

    @Override
    public final void characters(char[] ch, int start, int length) {
        StringBuilder s = this.text;
        (s != null ? s : (this.text = new StringBuilder())).append(ch, start, length);
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.endTag();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.text = null;
        this.pathList.remove(this.pathList.size() - 1);
    }

    protected abstract void endTag() throws Exception;
}

