/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.xml.pattern;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.xml.dom.XmlTag;

public class TextPattern {
    public final String open;
    public final String close;
    private final Map<String, String> varValues = new HashMap<String, String>();

    public static TextPattern create(String open, String close) {
        return new TextPattern(open, close);
    }

    public static TextPattern of() {
        return TextPattern.create("{{", "}}");
    }

    public TextPattern setVarValue(String varName, String varValue) {
        this.varValues.put(varName, varValue);
        return this;
    }

    public String convert(String source) {
        int i2;
        int i1;
        if (source == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int length = source.length();
        while (index < length && (i1 = source.indexOf(this.open, index)) >= 0 && (i2 = source.indexOf(this.close, i1 + this.open.length())) >= 0) {
            String varValue;
            sb.append(source, index, i1);
            String varName = source.substring(i1 + this.open.length(), i2);
            if (varName.length() > 0 && (varValue = this.varValues.get(varName)) != null) {
                sb.append(varValue);
            }
            index = i2 + this.close.length();
        }
        if (index < length) {
            sb.append(source, index, length);
        }
        return sb.toString();
    }

    public XmlTag convertToXml(String xmlText) {
        return XmlTag.parseXmlText(this.convert(xmlText));
    }

    private TextPattern(String open, String close) {
        this.open = open;
        this.close = close;
    }
}

