
package com.sforce.soap.tooling;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FilterScope.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="FilterScope"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="Everything"/&gt;
 *     &lt;enumeration value="Mine"/&gt;
 *     &lt;enumeration value="Queue"/&gt;
 *     &lt;enumeration value="Delegated"/&gt;
 *     &lt;enumeration value="MyTerritory"/&gt;
 *     &lt;enumeration value="MyTeamTerritory"/&gt;
 *     &lt;enumeration value="Team"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "FilterScope")
@XmlEnum
public enum FilterScope {

    @XmlEnumValue("Everything")
    EVERYTHING("Everything"),
    @XmlEnumValue("Mine")
    MINE("Mine"),
    @XmlEnumValue("Queue")
    QUEUE("Queue"),
    @XmlEnumValue("Delegated")
    DELEGATED("Delegated"),
    @XmlEnumValue("MyTerritory")
    MY_TERRITORY("MyTerritory"),
    @XmlEnumValue("MyTeamTerritory")
    MY_TEAM_TERRITORY("MyTeamTerritory"),
    @XmlEnumValue("Team")
    TEAM("Team");
    private final String value;

    FilterScope(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FilterScope fromValue(String v) {
        for (FilterScope c: FilterScope.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
