package com.sforce.soap.tooling;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

/**
 * This class was generated by Apache CXF 3.1.4
 * 2016-01-21T03:05:29.930+06:00
 * Generated source version: 3.1.4
 * 
 */
@WebService(targetNamespace = "urn:tooling.soap.sforce.com", name = "ToolingConnection")
@XmlSeeAlso({com.sforce.soap.tooling.metadata.ObjectFactory.class, ObjectFactory.class})
public interface ToolingConnection {

    /**
     * Delete a set of sObjects based on object id
     */
    @WebMethod
    @RequestWrapper(localName = "delete", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Delete")
    @ResponseWrapper(localName = "deleteResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DeleteResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.util.List<com.sforce.soap.tooling.DeleteResult> delete(
        @WebParam(name = "ids", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<java.lang.String> ids,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "MetadataWarningsHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        MetadataWarningsHeader metadataWarningsHeader,
        @WebParam(name = "AllOrNoneHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        AllOrNoneHeader allOrNoneHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Login to the Salesforce.com SOAP Api
     */
    @WebMethod
    @RequestWrapper(localName = "login", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Login")
    @ResponseWrapper(localName = "loginResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.LoginResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.LoginResult login(
        @WebParam(name = "username", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String username,
        @WebParam(name = "password", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String password
    );

    /**
     * Create a Query Cursor, including deleted sObjects
     */
    @WebMethod
    @RequestWrapper(localName = "queryAll", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.QueryAll")
    @ResponseWrapper(localName = "queryAllResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.QueryAllResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.QueryResult queryAll(
        @WebParam(name = "queryString", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String queryString,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Update a set of sObjects
     */
    @WebMethod
    @RequestWrapper(localName = "update", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Update")
    @ResponseWrapper(localName = "updateResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.UpdateResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.util.List<com.sforce.soap.tooling.SaveResult> update(
        @WebParam(name = "sObjects", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<com.sforce.soap.tooling.SObject> sObjects,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "MetadataWarningsHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        MetadataWarningsHeader metadataWarningsHeader,
        @WebParam(name = "AllOrNoneHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        AllOrNoneHeader allOrNoneHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Describe an sObject
     */
    @WebMethod
    @RequestWrapper(localName = "describeSObject", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeSObject")
    @ResponseWrapper(localName = "describeSObjectResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeSObjectResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.DescribeSObjectResult describeSObject(
        @WebParam(name = "type", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String type,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Describe a complex value type
     */
    @WebMethod
    @RequestWrapper(localName = "describeValueType", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeValueType")
    @ResponseWrapper(localName = "describeValueTypeResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeValueTypeResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.DescribeValueTypeResult describeValueType(
        @WebParam(name = "type", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String type,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Gets server timestamp
     */
    @WebMethod
    @RequestWrapper(localName = "getServerTimestamp", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.GetServerTimestamp")
    @ResponseWrapper(localName = "getServerTimestampResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.GetServerTimestampResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.GetServerTimestampResult getServerTimestamp(
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Set a user's password
     */
    @WebMethod
    @RequestWrapper(localName = "setPassword", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.SetPassword")
    @ResponseWrapper(localName = "setPasswordResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.SetPasswordResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.SetPasswordResult setPassword(
        @WebParam(name = "userId", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String userId,
        @WebParam(name = "password", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String password,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Execute asynchronous runTests
     */
    @WebMethod
    @RequestWrapper(localName = "runTestsAsynchronous", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.RunTestsAsynchronous")
    @ResponseWrapper(localName = "runTestsAsynchronousResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.RunTestsAsynchronousResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.lang.String runTestsAsynchronous(
        @WebParam(name = "String", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String string,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "DebuggingHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        DebuggingHeader debuggingHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions,
        @WebParam(mode = WebParam.Mode.OUT, name = "DebuggingInfo", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        javax.xml.ws.Holder<DebuggingInfo> debuggingInfo
    );

    /**
     * Execute an anonymous Apex code block
     */
    @WebMethod
    @RequestWrapper(localName = "executeAnonymous", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.ExecuteAnonymous")
    @ResponseWrapper(localName = "executeAnonymousResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.ExecuteAnonymousResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.ExecuteAnonymousResult executeAnonymous(
        @WebParam(name = "String", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String string,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "DebuggingHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        DebuggingHeader debuggingHeader,
        @WebParam(name = "PackageVersionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        PackageVersionHeader packageVersionHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions,
        @WebParam(name = "AllowFieldTruncationHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        AllowFieldTruncationHeader allowFieldTruncationHeader,
        @WebParam(name = "DisableFeedTrackingHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        DisableFeedTrackingHeader disableFeedTrackingHeader,
        @WebParam(mode = WebParam.Mode.OUT, name = "DebuggingInfo", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        javax.xml.ws.Holder<DebuggingInfo> debuggingInfo
    );

    /**
     * Create a set of new sObjects
     */
    @WebMethod
    @RequestWrapper(localName = "create", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Create")
    @ResponseWrapper(localName = "createResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.CreateResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.util.List<com.sforce.soap.tooling.SaveResult> create(
        @WebParam(name = "sObjects", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<com.sforce.soap.tooling.SObject> sObjects,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "MetadataWarningsHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        MetadataWarningsHeader metadataWarningsHeader,
        @WebParam(name = "AllOrNoneHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        AllOrNoneHeader allOrNoneHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Determine which actions are available for the given workitem
     */
    @WebMethod
    @RequestWrapper(localName = "describeWorkitemActions", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeWorkitemActions")
    @ResponseWrapper(localName = "describeWorkitemActionsResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeWorkitemActionsResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.util.List<com.sforce.soap.tooling.DescribeWorkitemActionResult> describeWorkitemActions(
        @WebParam(name = "workitemIds", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<java.lang.String> workitemIds,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Logs out and invalidates session ids
     */
    @WebMethod
    @RequestWrapper(localName = "invalidateSessions", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.InvalidateSessions")
    @ResponseWrapper(localName = "invalidateSessionsResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.InvalidateSessionsResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.util.List<com.sforce.soap.tooling.InvalidateSessionsResult> invalidateSessions(
        @WebParam(name = "ArrayList", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<java.lang.String> arrayList
    );

    /**
     * Execute test methods
     */
    @WebMethod
    @RequestWrapper(localName = "runTests", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.RunTests")
    @ResponseWrapper(localName = "runTestsResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.RunTestsResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.RunTestsResult runTests(
        @WebParam(name = "RunTestsRequest", targetNamespace = "urn:tooling.soap.sforce.com")
        com.sforce.soap.tooling.RunTestsRequest runTestsRequest,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "DebuggingHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        DebuggingHeader debuggingHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions,
        @WebParam(mode = WebParam.Mode.OUT, name = "DebuggingInfo", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        javax.xml.ws.Holder<DebuggingInfo> debuggingInfo
    );

    /**
     * Get the IDs for deleted sObjects
     */
    @WebMethod
    @RequestWrapper(localName = "getDeleted", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.GetDeleted")
    @ResponseWrapper(localName = "getDeletedResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.GetDeletedResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.GetDeletedResult getDeleted(
        @WebParam(name = "sObjectType", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String sObjectType,
        @WebParam(name = "start", targetNamespace = "urn:tooling.soap.sforce.com")
        javax.xml.datatype.XMLGregorianCalendar start,
        @WebParam(name = "end", targetNamespace = "urn:tooling.soap.sforce.com")
        javax.xml.datatype.XMLGregorianCalendar end,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Logout the current user, invalidating the current session.
     */
    @WebMethod
    @RequestWrapper(localName = "logout", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Logout")
    @ResponseWrapper(localName = "logoutResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.LogoutResponse")
    public void logout(
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Search for sObjects
     */
    @WebMethod
    @RequestWrapper(localName = "search", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Search")
    @ResponseWrapper(localName = "searchResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.SearchResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.SearchResult search(
        @WebParam(name = "searchString", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String searchString,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Get the IDs for updated sObjects
     */
    @WebMethod
    @RequestWrapper(localName = "getUpdated", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.GetUpdated")
    @ResponseWrapper(localName = "getUpdatedResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.GetUpdatedResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.GetUpdatedResult getUpdated(
        @WebParam(name = "sObjectType", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String sObjectType,
        @WebParam(name = "start", targetNamespace = "urn:tooling.soap.sforce.com")
        javax.xml.datatype.XMLGregorianCalendar start,
        @WebParam(name = "end", targetNamespace = "urn:tooling.soap.sforce.com")
        javax.xml.datatype.XMLGregorianCalendar end,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Update or insert a set of sObjects based on object id
     */
    @WebMethod
    @RequestWrapper(localName = "upsert", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Upsert")
    @ResponseWrapper(localName = "upsertResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.UpsertResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.util.List<com.sforce.soap.tooling.UpsertResult> upsert(
        @WebParam(name = "fieldName", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String fieldName,
        @WebParam(name = "entities", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<com.sforce.soap.tooling.SObject> entities,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "MetadataWarningsHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        MetadataWarningsHeader metadataWarningsHeader,
        @WebParam(name = "AllOrNoneHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        AllOrNoneHeader allOrNoneHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Create a Query Cursor
     */
    @WebMethod
    @RequestWrapper(localName = "query", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Query")
    @ResponseWrapper(localName = "queryResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.QueryResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.QueryResult query(
        @WebParam(name = "queryString", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String queryString,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Describe the Global state
     */
    @WebMethod
    @RequestWrapper(localName = "describeGlobal", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeGlobal")
    @ResponseWrapper(localName = "describeGlobalResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeGlobalResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.DescribeGlobalResult describeGlobal(
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Describe multiple sObjects (upto 100)
     */
    @WebMethod
    @RequestWrapper(localName = "describeSObjects", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeSObjects")
    @ResponseWrapper(localName = "describeSObjectsResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeSObjectsResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.util.List<com.sforce.soap.tooling.DescribeSObjectResult> describeSObjects(
        @WebParam(name = "types", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<java.lang.String> types,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Returns standard information relevant to the current user
     */
    @WebMethod
    @RequestWrapper(localName = "getUserInfo", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.GetUserInfo")
    @ResponseWrapper(localName = "getUserInfoResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.GetUserInfoResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.GetUserInfoResult getUserInfo(
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );

    /**
     * Get a set of sObjects
     */
    @WebMethod
    @RequestWrapper(localName = "retrieve", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.Retrieve")
    @ResponseWrapper(localName = "retrieveResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.RetrieveResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public java.util.List<com.sforce.soap.tooling.SObject> retrieve(
        @WebParam(name = "select", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String select,
        @WebParam(name = "type", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String type,
        @WebParam(name = "ids", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<java.lang.String> ids,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Gets the next batch of sObjects from a query
     */
    @WebMethod
    @RequestWrapper(localName = "queryMore", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.QueryMore")
    @ResponseWrapper(localName = "queryMoreResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.QueryMoreResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.QueryResult queryMore(
        @WebParam(name = "queryLocator", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String queryLocator,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader,
        @WebParam(name = "CallOptions", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        CallOptions callOptions
    );

    /**
     * Describe the layout of the given sObject or the given actionable global page.
     */
    @WebMethod
    @RequestWrapper(localName = "describeLayout", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeLayout")
    @ResponseWrapper(localName = "describeLayoutResponse", targetNamespace = "urn:tooling.soap.sforce.com", className = "com.sforce.soap.tooling.DescribeLayoutResponse")
    @WebResult(name = "result", targetNamespace = "urn:tooling.soap.sforce.com")
    public com.sforce.soap.tooling.DescribeLayoutResult describeLayout(
        @WebParam(name = "type", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String type,
        @WebParam(name = "layoutName", targetNamespace = "urn:tooling.soap.sforce.com")
        java.lang.String layoutName,
        @WebParam(name = "recordTypeIds", targetNamespace = "urn:tooling.soap.sforce.com")
        java.util.List<java.lang.String> recordTypeIds,
        @WebParam(name = "SessionHeader", targetNamespace = "urn:tooling.soap.sforce.com", header = true)
        SessionHeader sessionHeader
    );
}
