/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Unit;

public interface FormattedText {
    public static final Optional<Unit> STOP_ITERATION = Optional.of(Unit.INSTANCE);
    public static final FormattedText EMPTY = new FormattedText(){

        @Override
        public <T> Optional<T> visit(ContentConsumer<T> visitor) {
            return Optional.empty();
        }

        @Override
        public <T> Optional<T> visit(StyledContentConsumer<T> styledVisitor, Style style) {
            return Optional.empty();
        }
    };

    public static FormattedText of(final String string) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> visitor) {
                return visitor.accept(string);
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> styledVisitor, Style style) {
                return styledVisitor.accept(style, string);
            }
        };
    }

    public static FormattedText of(final String string, final Style style) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> visitor) {
                return visitor.accept(string);
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> styledVisitor, Style stylex) {
                return styledVisitor.accept(style.applyTo(style), string);
            }
        };
    }

    public static FormattedText composite(FormattedText ... visitables) {
        return FormattedText.composite((List<? extends FormattedText>)ImmutableList.copyOf((Object[])visitables));
    }

    public static FormattedText composite(final List<? extends FormattedText> visitables) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> visitor) {
                for (FormattedText formattedText : visitables) {
                    Optional<T> optional = formattedText.visit(visitor);
                    if (!optional.isPresent()) continue;
                    return optional;
                }
                return Optional.empty();
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> styledVisitor, Style style) {
                for (FormattedText formattedText : visitables) {
                    Optional<T> optional = formattedText.visit(styledVisitor, style);
                    if (!optional.isPresent()) continue;
                    return optional;
                }
                return Optional.empty();
            }
        };
    }

    public <T> Optional<T> visit(ContentConsumer<T> var1);

    public <T> Optional<T> visit(StyledContentConsumer<T> var1, Style var2);

    default public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.visit(string -> {
            stringBuilder.append(string);
            return Optional.empty();
        });
        return stringBuilder.toString();
    }

    public static interface ContentConsumer<T> {
        public Optional<T> accept(String var1);
    }

    public static interface StyledContentConsumer<T> {
        public Optional<T> accept(Style var1, String var2);
    }
}

