/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import land.vani.mcorouhlin.paper.component.AdventureComponent;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.BlockDataSource;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.EntityDataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.StorageDataSource;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;

public interface Component
extends Message,
FormattedText,
Iterable<Component> {
    public static Component nullToEmpty(@Nullable String string) {
        return string != null ? Component.literal(string) : CommonComponents.EMPTY;
    }

    public static MutableComponent literal(String string) {
        return MutableComponent.create((ComponentContents)new LiteralContents(string));
    }

    public static MutableComponent translatable(String key) {
        return MutableComponent.create((ComponentContents)new TranslatableContents(key));
    }

    public static MutableComponent translatable(String key, Object ... args) {
        return MutableComponent.create((ComponentContents)new TranslatableContents(key, args));
    }

    public static MutableComponent empty() {
        return MutableComponent.create((ComponentContents)ComponentContents.EMPTY);
    }

    public static MutableComponent keybind(String string) {
        return MutableComponent.create((ComponentContents)new KeybindContents(string));
    }

    public static MutableComponent nbt(String rawPath, boolean interpret, Optional<Component> separator, DataSource dataSource) {
        return MutableComponent.create((ComponentContents)new NbtContents(rawPath, interpret, separator, dataSource));
    }

    public static MutableComponent score(String name, String objective) {
        return MutableComponent.create((ComponentContents)new ScoreContents(name, objective));
    }

    public static MutableComponent selector(String pattern, Optional<Component> separator) {
        return MutableComponent.create((ComponentContents)new SelectorContents(pattern, separator));
    }

    default public Stream<Component> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.getSiblings().stream().flatMap(Component::stream)});
    }

    @Override
    default public Iterator<Component> iterator() {
        return this.stream().iterator();
    }

    public Style getStyle();

    public ComponentContents getContents();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String getString(int length) {
        StringBuilder stringbuilder = new StringBuilder();
        this.visit(s -> {
            int j = length - stringbuilder.length();
            if (j <= 0) {
                return STOP_ITERATION;
            }
            stringbuilder.append(s.length() <= j ? s : s.substring(0, j));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<Component> getSiblings();

    default public MutableComponent plainCopy() {
        return MutableComponent.create((ComponentContents)this.getContents());
    }

    default public MutableComponent copy() {
        return new MutableComponent(this.getContents(), new ArrayList<Component>(this.getSiblings()), this.getStyle());
    }

    public FormattedCharSequence getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> styledVisitor, Style style) {
        Component ichatbasecomponent;
        Optional<T> optional1;
        Style chatmodifier1 = this.getStyle().applyTo(style);
        Optional<T> optional = this.getContents().visit(styledVisitor, chatmodifier1);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<Component> iterator = this.getSiblings().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).visit(styledVisitor, chatmodifier1)).isPresent());
        return optional1;
    }

    @Override
    default public <T> Optional<T> visit(FormattedText.ContentConsumer<T> visitor) {
        Component ichatbasecomponent;
        Optional<T> optional1;
        Optional<T> optional = this.getContents().visit(visitor);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<Component> iterator = this.getSiblings().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).visit(visitor)).isPresent());
        return optional1;
    }

    default public List<Component> toFlatList() {
        return this.toFlatList(Style.EMPTY);
    }

    default public List<Component> toFlatList(Style style) {
        ArrayList list = Lists.newArrayList();
        this.visit((chatmodifier1, s) -> {
            if (!s.isEmpty()) {
                list.add(Component.literal(s).withStyle(chatmodifier1));
            }
            return Optional.empty();
        }, style);
        return list;
    }

    default public boolean contains(Component text) {
        List<Component> list1;
        if (this.equals(text)) {
            return true;
        }
        List<Component> list = this.toFlatList();
        return Collections.indexOfSubList(list, list1 = text.toFlatList(this.getStyle())) != -1;
    }

    public static class Serializer
    implements JsonDeserializer<MutableComponent>,
    JsonSerializer<Component> {
        private static final Gson GSON = (Gson)Util.make(() -> {
            GsonBuilder gsonbuilder = new GsonBuilder();
            gsonbuilder.disableHtmlEscaping();
            gsonbuilder.registerTypeAdapter(AdventureComponent.class, (Object)new AdventureComponent.Serializer());
            gsonbuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Serializer());
            gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
            return gsonbuilder.create();
        });
        private static final Field JSON_READER_POS = (Field)Util.make(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", nosuchfieldexception);
            }
        });
        private static final Field JSON_READER_LINESTART = (Field)Util.make(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", nosuchfieldexception);
            }
        });

        private static Object unwrapTextArgument(Object text) {
            ComponentContents componentcontents;
            Component ichatbasecomponent;
            if (text instanceof Component && (ichatbasecomponent = (Component)text).getStyle().isEmpty() && ichatbasecomponent.getSiblings().isEmpty() && (componentcontents = ichatbasecomponent.getContents()) instanceof LiteralContents) {
                LiteralContents literalcontents = (LiteralContents)componentcontents;
                return literalcontents.text();
            }
            return text;
        }

        public static String toJson(Component text) {
            return GSON.toJson((Object)text);
        }

        public static String toStableJson(Component text) {
            return GsonHelper.toStableString((JsonElement)Serializer.toJsonTree(text));
        }

        public static JsonElement toJsonTree(Component text) {
            return GSON.toJsonTree((Object)text);
        }

        @Nullable
        public static MutableComponent fromJson(String json) {
            return (MutableComponent)GsonHelper.fromJson((Gson)GSON, (String)json, MutableComponent.class, (boolean)false);
        }

        @Nullable
        public static MutableComponent fromJson(JsonElement json) {
            return (MutableComponent)GSON.fromJson(json, MutableComponent.class);
        }

        @Nullable
        public static MutableComponent fromJsonLenient(String json) {
            return (MutableComponent)GsonHelper.fromJson((Gson)GSON, (String)json, MutableComponent.class, (boolean)true);
        }

        public static MutableComponent fromJson(com.mojang.brigadier.StringReader reader) {
            try {
                JsonReader jsonreader = new JsonReader((Reader)new StringReader(reader.getRemaining()));
                jsonreader.setLenient(false);
                MutableComponent ichatmutablecomponent = (MutableComponent)GSON.getAdapter(MutableComponent.class).read(jsonreader);
                reader.setCursor(reader.getCursor() + Serializer.getPos(jsonreader));
                return ichatmutablecomponent;
            }
            catch (IOException | StackOverflowError ioexception) {
                throw new JsonParseException(ioexception);
            }
        }

        private static int getPos(JsonReader reader) {
            try {
                return JSON_READER_POS.getInt(reader) - JSON_READER_LINESTART.getInt(reader) + 1;
            }
            catch (IllegalAccessException illegalaccessexception) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalaccessexception);
            }
        }

        public MutableComponent deserialize(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
            MutableComponent ichatmutablecomponent;
            if (jsonelement.isJsonPrimitive()) {
                return Component.literal(jsonelement.getAsString());
            }
            if (!jsonelement.isJsonObject()) {
                if (jsonelement.isJsonArray()) {
                    JsonArray jsonarray = jsonelement.getAsJsonArray();
                    MutableComponent ichatmutablecomponent2 = null;
                    for (JsonElement jsonelement1 : jsonarray) {
                        MutableComponent ichatmutablecomponent1 = this.deserialize(jsonelement1, jsonelement1.getClass(), jsondeserializationcontext);
                        if (ichatmutablecomponent2 == null) {
                            ichatmutablecomponent2 = ichatmutablecomponent1;
                            continue;
                        }
                        ichatmutablecomponent2.append((Component)ichatmutablecomponent1);
                    }
                    return ichatmutablecomponent2;
                }
                throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
            }
            JsonObject jsonobject = jsonelement.getAsJsonObject();
            if (jsonobject.has("text")) {
                s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"text");
                ichatmutablecomponent = s.isEmpty() ? Component.empty() : Component.literal(s);
            } else if (jsonobject.has("translate")) {
                s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"translate");
                if (jsonobject.has("with")) {
                    JsonArray jsonarray1 = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"with");
                    Object[] aobject = new Object[jsonarray1.size()];
                    for (int i = 0; i < aobject.length; ++i) {
                        aobject[i] = Serializer.unwrapTextArgument(this.deserialize(jsonarray1.get(i), type, jsondeserializationcontext));
                    }
                    ichatmutablecomponent = Component.translatable(s, aobject);
                } else {
                    ichatmutablecomponent = Component.translatable(s);
                }
            } else if (jsonobject.has("score")) {
                JsonObject jsonobject1 = GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)"score");
                if (!jsonobject1.has("name") || !jsonobject1.has("objective")) {
                    throw new JsonParseException("A score component needs a least a name and an objective");
                }
                ichatmutablecomponent = Component.score(GsonHelper.getAsString((JsonObject)jsonobject1, (String)"name"), GsonHelper.getAsString((JsonObject)jsonobject1, (String)"objective"));
            } else if (jsonobject.has("selector")) {
                Optional<Component> optional = this.parseSeparator(type, jsondeserializationcontext, jsonobject);
                ichatmutablecomponent = Component.selector(GsonHelper.getAsString((JsonObject)jsonobject, (String)"selector"), optional);
            } else if (jsonobject.has("keybind")) {
                ichatmutablecomponent = Component.keybind(GsonHelper.getAsString((JsonObject)jsonobject, (String)"keybind"));
            } else {
                BlockDataSource object;
                if (!jsonobject.has("nbt")) {
                    throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
                }
                s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"nbt");
                Optional<Component> optional1 = this.parseSeparator(type, jsondeserializationcontext, jsonobject);
                boolean flag = GsonHelper.getAsBoolean((JsonObject)jsonobject, (String)"interpret", (boolean)false);
                if (jsonobject.has("block")) {
                    object = new BlockDataSource(GsonHelper.getAsString((JsonObject)jsonobject, (String)"block"));
                } else if (jsonobject.has("entity")) {
                    object = new EntityDataSource(GsonHelper.getAsString((JsonObject)jsonobject, (String)"entity"));
                } else {
                    if (!jsonobject.has("storage")) {
                        throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
                    }
                    object = new StorageDataSource(new ResourceLocation(GsonHelper.getAsString((JsonObject)jsonobject, (String)"storage")));
                }
                ichatmutablecomponent = Component.nbt(s, flag, optional1, (DataSource)object);
            }
            if (jsonobject.has("extra")) {
                JsonArray jsonarray2 = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"extra");
                if (jsonarray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                for (int j = 0; j < jsonarray2.size(); ++j) {
                    ichatmutablecomponent.append((Component)this.deserialize(jsonarray2.get(j), type, jsondeserializationcontext));
                }
            }
            ichatmutablecomponent.setStyle((Style)jsondeserializationcontext.deserialize(jsonelement, Style.class));
            return ichatmutablecomponent;
        }

        private Optional<Component> parseSeparator(Type type, JsonDeserializationContext context, JsonObject json) {
            return json.has("separator") ? Optional.of(this.deserialize(json.get("separator"), type, context)) : Optional.empty();
        }

        private void serializeStyle(Style style, JsonObject json, JsonSerializationContext context) {
            JsonElement jsonelement = context.serialize((Object)style);
            if (jsonelement.isJsonObject()) {
                JsonObject jsonobject1 = (JsonObject)jsonelement;
                for (Map.Entry entry : jsonobject1.entrySet()) {
                    json.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public JsonElement serialize(Component ichatbasecomponent, Type type, JsonSerializationContext jsonserializationcontext) {
            ComponentContents componentcontents;
            if (ichatbasecomponent instanceof AdventureComponent) {
                return jsonserializationcontext.serialize((Object)ichatbasecomponent);
            }
            JsonObject jsonobject = new JsonObject();
            if (!ichatbasecomponent.getStyle().isEmpty()) {
                this.serializeStyle(ichatbasecomponent.getStyle(), jsonobject, jsonserializationcontext);
            }
            if (!ichatbasecomponent.getSiblings().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Component ichatbasecomponent1 : ichatbasecomponent.getSiblings()) {
                    jsonarray.add(this.serialize(ichatbasecomponent1, (Type)((Object)Component.class), jsonserializationcontext));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if ((componentcontents = ichatbasecomponent.getContents()) == ComponentContents.EMPTY) {
                jsonobject.addProperty("text", "");
            } else if (componentcontents instanceof LiteralContents) {
                LiteralContents literalcontents = (LiteralContents)componentcontents;
                jsonobject.addProperty("text", literalcontents.text());
            } else if (componentcontents instanceof TranslatableContents) {
                TranslatableContents translatablecontents = (TranslatableContents)componentcontents;
                jsonobject.addProperty("translate", translatablecontents.getKey());
                if (translatablecontents.getArgs().length > 0) {
                    JsonArray jsonarray1 = new JsonArray();
                    for (Object object : translatablecontents.getArgs()) {
                        if (object instanceof Component) {
                            jsonarray1.add(this.serialize((Component)object, object.getClass(), jsonserializationcontext));
                            continue;
                        }
                        jsonarray1.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                    }
                    jsonobject.add("with", (JsonElement)jsonarray1);
                }
            } else if (componentcontents instanceof ScoreContents) {
                ScoreContents scorecontents = (ScoreContents)componentcontents;
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("name", scorecontents.getName());
                jsonobject1.addProperty("objective", scorecontents.getObjective());
                jsonobject.add("score", (JsonElement)jsonobject1);
            } else if (componentcontents instanceof SelectorContents) {
                SelectorContents selectorcontents = (SelectorContents)componentcontents;
                jsonobject.addProperty("selector", selectorcontents.getPattern());
                this.serializeSeparator(jsonserializationcontext, jsonobject, selectorcontents.getSeparator());
            } else if (componentcontents instanceof KeybindContents) {
                KeybindContents keybindcontents = (KeybindContents)componentcontents;
                jsonobject.addProperty("keybind", keybindcontents.getName());
            } else {
                if (!(componentcontents instanceof NbtContents)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                }
                NbtContents nbtcontents = (NbtContents)componentcontents;
                jsonobject.addProperty("nbt", nbtcontents.getNbtPath());
                jsonobject.addProperty("interpret", Boolean.valueOf(nbtcontents.isInterpreting()));
                this.serializeSeparator(jsonserializationcontext, jsonobject, nbtcontents.getSeparator());
                DataSource datasource = nbtcontents.getDataSource();
                if (datasource instanceof BlockDataSource) {
                    BlockDataSource blockdatasource = (BlockDataSource)datasource;
                    jsonobject.addProperty("block", blockdatasource.posPattern());
                } else if (datasource instanceof EntityDataSource) {
                    EntityDataSource entitydatasource = (EntityDataSource)datasource;
                    jsonobject.addProperty("entity", entitydatasource.selectorPattern());
                } else {
                    if (!(datasource instanceof StorageDataSource)) {
                        throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                    }
                    StorageDataSource storagedatasource = (StorageDataSource)datasource;
                    jsonobject.addProperty("storage", storagedatasource.id().toString());
                }
            }
            return jsonobject;
        }

        private void serializeSeparator(JsonSerializationContext context, JsonObject json, Optional<Component> separator) {
            separator.ifPresent(ichatbasecomponent -> json.add("separator", this.serialize((Component)ichatbasecomponent, (Type)ichatbasecomponent.getClass(), context)));
        }
    }
}

