/*
 * Decompiled with CFR 0.152.
 */
package li.chee.vertx.reststorage;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import li.chee.vertx.reststorage.UrlParser;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.http.CaseInsensitiveMultiMap;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.HttpVersion;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.net.NetSocket;

public class EventBusAdapter {
    public void init(final Vertx vertx, String address, final Handler<HttpServerRequest> requestHandler) {
        vertx.eventBus().registerHandler(address, (Handler)new Handler<Message<Buffer>>(){

            public void handle(Message<Buffer> message) {
                requestHandler.handle((Object)new MappedHttpServerRequest(vertx, message));
            }
        });
    }

    public static JsonArray toJson(MultiMap multiMap) {
        JsonArray result = new JsonArray();
        for (Map.Entry entry : multiMap.entries()) {
            result.addArray(new JsonArray().add(entry.getKey()).add(entry.getValue()));
        }
        return result;
    }

    public static MultiMap fromJson(JsonArray json) {
        CaseInsensitiveMultiMap result = new CaseInsensitiveMultiMap();
        for (Object next : json) {
            JsonArray pair;
            if (!(next instanceof JsonArray) || (pair = (JsonArray)next).size() != 2) continue;
            result.add(pair.get(0).toString(), pair.get(1).toString());
        }
        return result;
    }

    private class MappedHttpServerRequest
    implements HttpServerRequest {
        private Vertx vertx;
        private Buffer requestPayload;
        private String method;
        private String uri;
        private String path;
        private String query;
        private MultiMap params;
        private MultiMap requestHeaders;
        private Message<Buffer> message;
        private Handler<Buffer> dataHandler;
        private Handler<Void> endHandler;
        private HttpServerResponse response;

        private MappedHttpServerRequest(Vertx vertx, Message<Buffer> message) {
            this.vertx = vertx;
            this.message = message;
            Buffer buffer = (Buffer)message.body();
            int headerLength = buffer.getInt(0);
            JsonObject header = new JsonObject(buffer.getString(4, headerLength + 4));
            this.method = header.getString("method");
            this.uri = header.getString("uri");
            this.requestPayload = buffer.getBuffer(headerLength + 4, buffer.length());
            JsonArray headerArray = header.getArray("headers");
            this.requestHeaders = headerArray != null ? EventBusAdapter.fromJson(headerArray) : new CaseInsensitiveMultiMap();
        }

        public HttpVersion version() {
            return HttpVersion.HTTP_1_0;
        }

        public String method() {
            return this.method;
        }

        public String uri() {
            return this.uri;
        }

        public String path() {
            if (this.path == null) {
                this.path = UrlParser.path(this.uri);
            }
            return this.path;
        }

        public String query() {
            if (this.query == null) {
                this.query = UrlParser.query(this.uri);
            }
            return this.query;
        }

        public HttpServerResponse response() {
            if (this.response == null) {
                this.response = new HttpServerResponse(){
                    private int statusCode;
                    private String statusMessage;
                    private MultiMap responseHeaders = new CaseInsensitiveMultiMap();
                    private Buffer responsePayload = new Buffer();

                    public int getStatusCode() {
                        return this.statusCode;
                    }

                    public HttpServerResponse setStatusCode(int i) {
                        this.statusCode = i;
                        return this;
                    }

                    public String getStatusMessage() {
                        return this.statusMessage;
                    }

                    public HttpServerResponse setStatusMessage(String s) {
                        this.statusMessage = s;
                        return this;
                    }

                    public HttpServerResponse setChunked(boolean b) {
                        return this;
                    }

                    public boolean isChunked() {
                        return false;
                    }

                    public MultiMap headers() {
                        return this.responseHeaders;
                    }

                    public HttpServerResponse putHeader(String s, String s2) {
                        this.responseHeaders.set(s, s2);
                        return this;
                    }

                    public HttpServerResponse putHeader(CharSequence charSequence, CharSequence charSequence2) {
                        this.responseHeaders.set(charSequence, charSequence2);
                        return this;
                    }

                    public HttpServerResponse putHeader(String s, Iterable<String> strings) {
                        for (String value : strings) {
                            this.responseHeaders.add(s, value);
                        }
                        return this;
                    }

                    public HttpServerResponse putHeader(CharSequence charSequence, Iterable<CharSequence> charSequences) {
                        for (CharSequence value : charSequences) {
                            this.responseHeaders.add(charSequence, value);
                        }
                        return this;
                    }

                    public MultiMap trailers() {
                        throw new UnsupportedOperationException();
                    }

                    public HttpServerResponse putTrailer(String s, String s2) {
                        throw new UnsupportedOperationException();
                    }

                    public HttpServerResponse putTrailer(CharSequence charSequence, CharSequence charSequence2) {
                        throw new UnsupportedOperationException();
                    }

                    public HttpServerResponse putTrailer(String s, Iterable<String> strings) {
                        throw new UnsupportedOperationException();
                    }

                    public HttpServerResponse putTrailer(CharSequence charSequence, Iterable<CharSequence> charSequences) {
                        throw new UnsupportedOperationException();
                    }

                    public HttpServerResponse closeHandler(Handler<Void> voidHandler) {
                        return this;
                    }

                    public HttpServerResponse write(Buffer buffer) {
                        this.responsePayload.appendBuffer(buffer);
                        return this;
                    }

                    public HttpServerResponse write(String s, String s2) {
                        this.responsePayload.appendBuffer(new Buffer(s, s2));
                        return this;
                    }

                    public HttpServerResponse write(String s) {
                        this.responsePayload.appendBuffer(new Buffer(s));
                        return this;
                    }

                    public void end(String s) {
                        this.write(new Buffer(s));
                        this.end();
                    }

                    public void end(String s, String s2) {
                        this.write(s, s2);
                        this.end();
                    }

                    public void end(Buffer buffer) {
                        this.write(buffer);
                        this.end();
                    }

                    public void end() {
                        JsonObject header = new JsonObject();
                        if (this.statusCode == 0) {
                            this.statusCode = 200;
                            this.statusMessage = "OK";
                        }
                        header.putNumber("statusCode", (Number)this.statusCode);
                        header.putString("statusMessage", this.statusMessage);
                        header.putArray("headers", EventBusAdapter.toJson(this.responseHeaders));
                        Buffer bufferHeader = new Buffer(header.encode());
                        Buffer response = new Buffer(4 + bufferHeader.length() + this.responsePayload.length());
                        response.setInt(0, bufferHeader.length()).appendBuffer(bufferHeader).appendBuffer(this.responsePayload);
                        MappedHttpServerRequest.this.message.reply(response);
                    }

                    public HttpServerResponse sendFile(String s) {
                        throw new UnsupportedOperationException();
                    }

                    public HttpServerResponse sendFile(String s, String s2) {
                        throw new UnsupportedOperationException();
                    }

                    public HttpServerResponse sendFile(String s, Handler<AsyncResult<Void>> asyncResultHandler) {
                        throw new UnsupportedOperationException();
                    }

                    public HttpServerResponse sendFile(String s, String s2, Handler<AsyncResult<Void>> asyncResultHandler) {
                        throw new UnsupportedOperationException();
                    }

                    public void close() {
                    }

                    public HttpServerResponse setWriteQueueMaxSize(int i) {
                        return this;
                    }

                    public boolean writeQueueFull() {
                        return false;
                    }

                    public HttpServerResponse drainHandler(Handler<Void> voidHandler) {
                        return this;
                    }

                    public HttpServerResponse exceptionHandler(Handler<Throwable> throwableHandler) {
                        return this;
                    }
                };
            }
            return this.response;
        }

        public MultiMap headers() {
            return this.requestHeaders;
        }

        public MultiMap params() {
            if (this.params == null) {
                QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri());
                Map prms = queryStringDecoder.parameters();
                this.params = new CaseInsensitiveMultiMap();
                if (!prms.isEmpty()) {
                    for (Map.Entry entry : prms.entrySet()) {
                        this.params.add((String)entry.getKey(), (Iterable)entry.getValue());
                    }
                }
            }
            return this.params;
        }

        public InetSocketAddress remoteAddress() {
            throw new UnsupportedOperationException();
        }

        public InetSocketAddress localAddress() {
            throw new UnsupportedOperationException();
        }

        public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
            return new X509Certificate[0];
        }

        public URI absoluteURI() {
            return null;
        }

        public HttpServerRequest bodyHandler(final Handler<Buffer> bodyHandler) {
            final Buffer body = new Buffer();
            this.dataHandler(new Handler<Buffer>(){

                public void handle(Buffer buff) {
                    body.appendBuffer(buff);
                }
            });
            this.endHandler((Handler<Void>)new VoidHandler(){

                public void handle() {
                    bodyHandler.handle((Object)body);
                }
            });
            return this;
        }

        public NetSocket netSocket() {
            return null;
        }

        public HttpServerRequest expectMultiPart(boolean b) {
            return this;
        }

        public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> httpServerFileUploadHandler) {
            throw new UnsupportedOperationException();
        }

        public MultiMap formAttributes() {
            throw new UnsupportedOperationException();
        }

        public HttpServerRequest endHandler(Handler<Void> voidHandler) {
            this.endHandler = voidHandler;
            if (this.requestPayload == null) {
                this.endHandler.handle(null);
            }
            return this;
        }

        public HttpServerRequest dataHandler(Handler<Buffer> bufferHandler) {
            if (this.requestPayload != null) {
                this.dataHandler = bufferHandler;
                this.vertx.runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void aVoid) {
                        MappedHttpServerRequest.this.dataHandler.handle((Object)MappedHttpServerRequest.this.requestPayload);
                        MappedHttpServerRequest.this.endHandler.handle(null);
                    }
                });
            }
            return this;
        }

        public HttpServerRequest pause() {
            return this;
        }

        public HttpServerRequest resume() {
            return this;
        }

        public HttpServerRequest exceptionHandler(Handler<Throwable> throwableHandler) {
            return this;
        }
    }
}

