/*
 * Decompiled with CFR 0.152.
 */
package li.chee.vertx.reststorage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import li.chee.vertx.reststorage.CollectionResource;
import li.chee.vertx.reststorage.DocumentResource;
import li.chee.vertx.reststorage.Resource;
import li.chee.vertx.reststorage.Storage;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.file.FileProps;
import org.vertx.java.core.file.FileSystem;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class FileSystemStorage
implements Storage {
    private String root;
    private Vertx vertx;

    public FileSystemStorage(Vertx vertx, String root) {
        this.vertx = vertx;
        this.root = root;
    }

    @Override
    public void get(String path, String etag, final int offset, final int count, final Handler<Resource> handler) {
        final String fullPath = this.canonicalize(path);
        this.fileSystem().exists(fullPath, (Handler)new AsyncResultHandler<Boolean>(){

            public void handle(AsyncResult<Boolean> event) {
                if (((Boolean)event.result()).booleanValue()) {
                    FileSystemStorage.this.fileSystem().props(fullPath, (Handler)new AsyncResultHandler<FileProps>(){

                        public void handle(AsyncResult<FileProps> event) {
                            final FileProps props = (FileProps)event.result();
                            if (props.isDirectory()) {
                                FileSystemStorage.this.fileSystem().readDir(fullPath, (Handler)new AsyncResultHandler<String[]>(){

                                    public void handle(AsyncResult<String[]> event) {
                                        final int length = ((String[])event.result()).length;
                                        final CollectionResource c = new CollectionResource();
                                        c.items = new ArrayList<Resource>(length);
                                        if (length == 0) {
                                            handler.handle((Object)c);
                                            return;
                                        }
                                        final int dirLength = fullPath.length();
                                        for (final String item : (String[])event.result()) {
                                            FileSystemStorage.this.fileSystem().props(item, (Handler)new AsyncResultHandler<FileProps>(){

                                                public void handle(AsyncResult<FileProps> itemProp) {
                                                    Resource r;
                                                    if (((FileProps)itemProp.result()).isDirectory()) {
                                                        r = new CollectionResource();
                                                    } else if (((FileProps)itemProp.result()).isRegularFile()) {
                                                        r = new DocumentResource();
                                                    } else {
                                                        r = new Resource();
                                                        r.exists = false;
                                                    }
                                                    r.name = item.substring(dirLength + 1);
                                                    c.items.add(r);
                                                    if (c.items.size() == length) {
                                                        Collections.sort(c.items);
                                                        int n = count;
                                                        if (n == -1) {
                                                            n = length;
                                                        }
                                                        if (offset > -1) {
                                                            if (offset >= c.items.size() || offset + n >= c.items.size() || offset == 0 && n == -1) {
                                                                handler.handle((Object)c);
                                                            } else {
                                                                c.items = c.items.subList(offset, offset + n);
                                                                handler.handle((Object)c);
                                                            }
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    }
                                });
                            } else if (props.isRegularFile()) {
                                FileSystemStorage.this.fileSystem().open(fullPath, (Handler)new AsyncResultHandler<AsyncFile>(){

                                    public void handle(final AsyncResult<AsyncFile> event) {
                                        DocumentResource d = new DocumentResource();
                                        d.length = props.size();
                                        d.readStream = (ReadStream)event.result();
                                        d.closeHandler = new Handler<Void>(){

                                            public void handle(Void v) {
                                                ((AsyncFile)event.result()).close();
                                            }
                                        };
                                        handler.handle((Object)d);
                                    }
                                });
                            } else {
                                Resource r = new Resource();
                                r.exists = false;
                                handler.handle((Object)r);
                            }
                        }
                    });
                } else {
                    Resource r = new Resource();
                    r.exists = false;
                    handler.handle((Object)r);
                }
            }
        });
    }

    @Override
    public void put(String path, String etag, boolean merge, long expire, final Handler<Resource> handler) {
        final String fullPath = this.canonicalize(path);
        this.fileSystem().exists(fullPath, (Handler)new AsyncResultHandler<Boolean>(){

            public void handle(AsyncResult<Boolean> event) {
                if (((Boolean)event.result()).booleanValue()) {
                    FileSystemStorage.this.fileSystem().props(fullPath, (Handler)new AsyncResultHandler<FileProps>(){

                        public void handle(AsyncResult<FileProps> event) {
                            FileProps props = (FileProps)event.result();
                            if (props.isDirectory()) {
                                CollectionResource c = new CollectionResource();
                                handler.handle((Object)c);
                            } else if (props.isRegularFile()) {
                                FileSystemStorage.this.putFile((Handler<Resource>)handler, fullPath);
                            } else {
                                Resource r = new Resource();
                                r.exists = false;
                                handler.handle((Object)r);
                            }
                        }
                    });
                } else {
                    final String dirName = FileSystemStorage.this.dirName(fullPath);
                    FileSystemStorage.this.fileSystem().exists(dirName, (Handler)new AsyncResultHandler<Boolean>(){

                        public void handle(AsyncResult<Boolean> event) {
                            if (((Boolean)event.result()).booleanValue()) {
                                FileSystemStorage.this.putFile((Handler<Resource>)handler, fullPath);
                            } else {
                                FileSystemStorage.this.fileSystem().mkdir(dirName, true, (Handler)new AsyncResultHandler<Void>(){

                                    public void handle(AsyncResult<Void> event) {
                                        FileSystemStorage.this.putFile((Handler<Resource>)handler, fullPath);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    private void putFile(final Handler<Resource> handler, final String fullPath) {
        final String tempFile = fullPath + "." + UUID.randomUUID().toString();
        this.fileSystem().open(tempFile, (Handler)new AsyncResultHandler<AsyncFile>(){

            public void handle(final AsyncResult<AsyncFile> event) {
                if (event.succeeded()) {
                    final DocumentResource d = new DocumentResource();
                    d.writeStream = (WriteStream)event.result();
                    d.closeHandler = new Handler<Void>(){

                        public void handle(Void v) {
                            ((AsyncFile)event.result()).close((Handler)new AsyncResultHandler<Void>(){

                                public void handle(AsyncResult<Void> event) {
                                    FileSystemStorage.this.fileSystem().delete(fullPath, (Handler)new AsyncResultHandler<Void>(){

                                        public void handle(AsyncResult<Void> event) {
                                            FileSystemStorage.this.fileSystem().move(tempFile, fullPath, (Handler)new AsyncResultHandler<Void>(){

                                                public void handle(AsyncResult<Void> event) {
                                                    d.endHandler.handle(null);
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    };
                    handler.handle((Object)d);
                } else {
                    Resource r = new Resource();
                    r.exists = false;
                    handler.handle((Object)r);
                }
            }
        });
    }

    @Override
    public void delete(String path, final Handler<Resource> handler) {
        final String fullPath = this.canonicalize(path);
        this.fileSystem().exists(fullPath, (Handler)new AsyncResultHandler<Boolean>(){

            public void handle(AsyncResult<Boolean> event) {
                if (((Boolean)event.result()).booleanValue()) {
                    FileSystemStorage.this.fileSystem().delete(fullPath, true, (Handler)new AsyncResultHandler<Void>(){

                        public void handle(AsyncResult<Void> event) {
                            Resource resource = new Resource();
                            if (event.failed()) {
                                resource.exists = false;
                            }
                            handler.handle((Object)resource);
                        }
                    });
                } else {
                    Resource r = new Resource();
                    r.exists = false;
                    handler.handle((Object)r);
                }
            }
        });
    }

    private String canonicalize(String path) {
        try {
            return new File(this.root + path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String dirName(String path) {
        return new File(path).getParent();
    }

    private FileSystem fileSystem() {
        return this.vertx.fileSystem();
    }

    @Override
    public void cleanup(Handler<DocumentResource> handler, String cleanupResourcesAmount) {
    }
}

