/*
 * Decompiled with CFR 0.152.
 */
package li.chee.vertx.reststorage;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MimeTypeResolver {
    private Map<String, String> mimeTypes = new HashMap<String, String>();
    private String defaultMimeType;

    public MimeTypeResolver(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
        Properties props = new Properties();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("mime-types.properties");
        try {
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.mimeTypes.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
        }
    }

    public String resolveMimeType(String path) {
        int dot;
        int lastSlash = path.lastIndexOf("/");
        String part = path;
        if (lastSlash >= 0 && !path.endsWith("/")) {
            part = part.substring(lastSlash + 1);
        }
        if ((dot = part.lastIndexOf(".")) == -1 || part.endsWith(".")) {
            return this.defaultMimeType;
        }
        String extension = part.substring(dot + 1);
        String type = this.mimeTypes.get(extension.toLowerCase());
        if (type == null) {
            type = "text/plain";
        }
        return type;
    }
}

