/*
 * Decompiled with CFR 0.152.
 */
package li.chee.vertx.reststorage;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import li.chee.vertx.reststorage.CollectionResource;
import li.chee.vertx.reststorage.DocumentResource;
import li.chee.vertx.reststorage.Resource;
import li.chee.vertx.reststorage.Storage;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class RedisStorage
implements Storage {
    private static final String MAX_EXPIRE_IN_MILLIS = "9999999999999";
    private static final int CLEANUP_BULK_SIZE = 200;
    private String redisAddress;
    private String redisResourcesPrefix;
    private String redisCollectionsPrefix;
    private String redisDeltaResourcesPrefix;
    private String redisDeltaEtagsPrefix;
    private String expirableSet;
    private long cleanupResourcesAmount;
    private EventBus eb;
    private Vertx vertx;
    private Logger log;
    private Map<LuaScript, LuaScriptState> luaScripts = new HashMap<LuaScript, LuaScriptState>();

    public RedisStorage(Vertx vertx, Logger log, String redisAddress, String redisResourcesPrefix, String redisCollectionsPrefix, String redisDeltaResourcesPrefix, String redisDeltaEtagsPrefix, String expirableSet, long cleanupResourcesAmount) {
        this.redisAddress = redisAddress;
        this.expirableSet = expirableSet;
        this.redisResourcesPrefix = redisResourcesPrefix;
        this.redisCollectionsPrefix = redisCollectionsPrefix;
        this.redisDeltaResourcesPrefix = redisDeltaResourcesPrefix;
        this.redisDeltaEtagsPrefix = redisDeltaEtagsPrefix;
        this.cleanupResourcesAmount = cleanupResourcesAmount;
        this.eb = vertx.eventBus();
        this.vertx = vertx;
        this.log = log;
        LuaScriptState luaGetScriptState = new LuaScriptState(LuaScript.GET, false);
        luaGetScriptState.loadLuaScript(new RedisCommandDoNothing(), 0);
        this.luaScripts.put(LuaScript.GET, luaGetScriptState);
        LuaScriptState luaPutScriptState = new LuaScriptState(LuaScript.PUT, false);
        luaPutScriptState.loadLuaScript(new RedisCommandDoNothing(), 0);
        this.luaScripts.put(LuaScript.PUT, luaPutScriptState);
        LuaScriptState luaDeleteScriptState = new LuaScriptState(LuaScript.DELETE, false);
        luaDeleteScriptState.loadLuaScript(new RedisCommandDoNothing(), 0);
        this.luaScripts.put(LuaScript.DELETE, luaDeleteScriptState);
        LuaScriptState luaCleanupScriptState = new LuaScriptState(LuaScript.CLEANUP, false);
        luaCleanupScriptState.loadLuaScript(new RedisCommandDoNothing(), 0);
        this.luaScripts.put(LuaScript.CLEANUP, luaCleanupScriptState);
    }

    private void reloadScriptIfLoglevelChangedAndExecuteRedisCommand(LuaScript luaScript, RedisCommand redisCommand, int executionCounter) {
        LuaScriptState luaScriptState;
        boolean logoutput = this.log.isTraceEnabled();
        if (logoutput == (luaScriptState = this.luaScripts.get((Object)luaScript)).getLogoutput()) {
            redisCommand.exec(executionCounter);
            return;
        }
        if (logoutput && !luaScriptState.getLogoutput()) {
            luaScriptState.setLogoutput(true);
            luaScriptState.recomposeLuaScript();
        } else if (!logoutput && luaScriptState.getLogoutput()) {
            luaScriptState.setLogoutput(false);
            luaScriptState.recomposeLuaScript();
        }
        luaScriptState.loadLuaScript(redisCommand, executionCounter);
    }

    @Override
    public void get(String path, String etag, int offset, int limit, Handler<Resource> handler) {
        String key = this.encodePath(path);
        JsonObject command = new JsonObject();
        command.putString("command", "evalsha");
        JsonArray args = new JsonArray();
        args.add((Object)this.luaScripts.get((Object)LuaScript.GET).getSha());
        args.add((Object)1);
        args.add((Object)key);
        args.add((Object)this.redisResourcesPrefix);
        args.add((Object)this.redisCollectionsPrefix);
        args.add((Object)this.expirableSet);
        args.add((Object)String.valueOf(System.currentTimeMillis()));
        args.add((Object)MAX_EXPIRE_IN_MILLIS);
        args.add((Object)offset);
        args.add((Object)limit);
        args.add((Object)etag);
        command.putArray("args", args);
        this.reloadScriptIfLoglevelChangedAndExecuteRedisCommand(LuaScript.GET, new Get(command, handler), 0);
    }

    private void handleJsonArrayValues(JsonArray values, Handler<Resource> handler) {
        String type = (String)values.get(0);
        if ("TYPE_RESOURCE".equals(type)) {
            String valueStr = (String)values.get(1);
            DocumentResource r = new DocumentResource();
            byte[] content = this.decodeBinary(valueStr);
            r.readStream = new ByteArrayReadStream(content);
            r.length = content.length;
            r.etag = (String)values.get(2);
            r.closeHandler = new Handler<Void>(){

                public void handle(Void event) {
                }
            };
            handler.handle((Object)r);
        } else if ("TYPE_COLLECTION".equals(type)) {
            CollectionResource r = new CollectionResource();
            HashSet<Resource> items = new HashSet<Resource>();
            for (String member : values) {
                if ("TYPE_COLLECTION".equals(member)) continue;
                if (member.endsWith(":")) {
                    member = member.replaceAll(":$", "");
                    CollectionResource c = new CollectionResource();
                    c.name = member;
                    items.add(c);
                    continue;
                }
                DocumentResource d = new DocumentResource();
                d.name = member;
                items.add(d);
            }
            r.items = new ArrayList<Resource>(items);
            Collections.sort(r.items);
            handler.handle((Object)r);
        } else {
            this.notFound(handler);
        }
    }

    private String initEtagValue(String providedEtag) {
        if (!this.isEmpty(providedEtag)) {
            return providedEtag;
        }
        return UUID.randomUUID().toString();
    }

    @Override
    public void put(String path, String etag, final boolean merge, final long expire, final Handler<Resource> handler) {
        final String key = this.encodePath(path);
        final DocumentResource d = new DocumentResource();
        final ByteArrayWriteStream stream = new ByteArrayWriteStream();
        final String etagValue = this.initEtagValue(etag);
        d.writeStream = stream;
        d.closeHandler = new Handler<Void>(){

            public void handle(Void event) {
                String expireInMillis = RedisStorage.MAX_EXPIRE_IN_MILLIS;
                if (expire > -1L) {
                    expireInMillis = String.valueOf(System.currentTimeMillis() + expire * 1000L);
                }
                JsonObject command = new JsonObject();
                command.putString("command", "evalsha");
                JsonArray args = new JsonArray();
                args.add((Object)((LuaScriptState)RedisStorage.this.luaScripts.get((Object)LuaScript.PUT)).getSha());
                args.add((Object)1);
                args.add((Object)key);
                args.add((Object)RedisStorage.this.redisResourcesPrefix);
                args.add((Object)RedisStorage.this.redisCollectionsPrefix);
                args.add((Object)RedisStorage.this.expirableSet);
                args.add((Object)(merge ? "true" : "false"));
                args.add((Object)expireInMillis);
                args.add((Object)RedisStorage.MAX_EXPIRE_IN_MILLIS);
                args.add((Object)RedisStorage.this.encodeBinary(stream.getBytes()));
                args.add((Object)etagValue);
                command.putArray("args", args);
                RedisStorage.this.reloadScriptIfLoglevelChangedAndExecuteRedisCommand(LuaScript.PUT, new Put(d, command, (Handler<Resource>)handler), 0);
            }
        };
        handler.handle((Object)d);
    }

    @Override
    public void delete(String path, Handler<Resource> handler) {
        String key = this.encodePath(path);
        JsonObject command = new JsonObject();
        command.putString("command", "evalsha");
        JsonArray args = new JsonArray();
        args.add((Object)this.luaScripts.get((Object)LuaScript.DELETE).getSha());
        args.add((Object)1);
        args.add((Object)key);
        args.add((Object)this.redisResourcesPrefix);
        args.add((Object)this.redisCollectionsPrefix);
        args.add((Object)this.redisDeltaResourcesPrefix);
        args.add((Object)this.redisDeltaEtagsPrefix);
        args.add((Object)this.expirableSet);
        args.add((Object)String.valueOf(System.currentTimeMillis()));
        args.add((Object)MAX_EXPIRE_IN_MILLIS);
        command.putArray("args", args);
        this.reloadScriptIfLoglevelChangedAndExecuteRedisCommand(LuaScript.DELETE, new Delete(command, handler), 0);
    }

    public void cleanupRecursive(final Handler<DocumentResource> handler, final long cleanedLastRun, final long maxdel, final int bulkSize) {
        JsonObject command = new JsonObject();
        command.putString("command", "evalsha");
        JsonArray args = new JsonArray();
        args.add((Object)this.luaScripts.get((Object)LuaScript.CLEANUP).getSha());
        args.add((Object)0);
        args.add((Object)this.redisResourcesPrefix);
        args.add((Object)this.redisCollectionsPrefix);
        args.add((Object)this.redisDeltaResourcesPrefix);
        args.add((Object)this.redisDeltaEtagsPrefix);
        args.add((Object)this.expirableSet);
        args.add((Object)"0");
        args.add((Object)MAX_EXPIRE_IN_MILLIS);
        args.add((Object)String.valueOf(System.currentTimeMillis()));
        args.add((Object)String.valueOf(bulkSize));
        command.putArray("args", args);
        this.eb.send(this.redisAddress, command, (Handler)new Handler<Message<JsonObject>>(){

            public void handle(Message<JsonObject> event) {
                String message;
                if (RedisStorage.this.log.isTraceEnabled()) {
                    RedisStorage.this.log.trace((Object)("RedisStorage cleanup resources result: " + ((JsonObject)event.body()).getString("status")));
                }
                if ("error".equals(((JsonObject)event.body()).getString("status")) && (message = ((JsonObject)event.body()).getString("message")) != null && message.startsWith("NOSCRIPT")) {
                    RedisStorage.this.log.warn((Object)"the cleanup script is not loaded. Load it and exit. The Cleanup will success the next time");
                    ((LuaScriptState)RedisStorage.this.luaScripts.get((Object)LuaScript.CLEANUP)).loadLuaScript(new RedisCommandDoNothing(), 0);
                    return;
                }
                Long cleanedThisRun = ((JsonObject)event.body()).getLong("value");
                if (RedisStorage.this.log.isTraceEnabled()) {
                    RedisStorage.this.log.trace((Object)("RedisStorage cleanup resources cleanded this run: " + cleanedThisRun));
                }
                final long cleaned = cleanedLastRun + cleanedThisRun;
                if (cleanedThisRun != 0L && cleaned < maxdel) {
                    if (RedisStorage.this.log.isTraceEnabled()) {
                        RedisStorage.this.log.trace((Object)"RedisStorage cleanup resources call recursive next bulk");
                    }
                    RedisStorage.this.cleanupRecursive((Handler<DocumentResource>)handler, cleaned, maxdel, bulkSize);
                } else {
                    JsonObject command = new JsonObject();
                    command.putString("command", "zcount");
                    JsonArray args = new JsonArray();
                    args.add((Object)RedisStorage.this.expirableSet);
                    args.add((Object)0);
                    args.add((Object)String.valueOf(System.currentTimeMillis()));
                    command.putArray("args", args);
                    RedisStorage.this.eb.send(RedisStorage.this.redisAddress, command, (Handler)new Handler<Message<JsonObject>>(){

                        public void handle(Message<JsonObject> event) {
                            Number result = ((JsonObject)event.body()).getNumber("value");
                            if (RedisStorage.this.log.isTraceEnabled()) {
                                RedisStorage.this.log.trace((Object)("RedisStorage cleanup resources zcount on expirable set: " + result));
                            }
                            int resToCleanLeft = 0;
                            if (result != null && result.intValue() >= 0) {
                                resToCleanLeft = result.intValue();
                            }
                            JsonObject retObj = new JsonObject();
                            retObj.putString("cleanedResources", String.valueOf(cleaned));
                            retObj.putString("expiredResourcesLeft", String.valueOf(resToCleanLeft));
                            DocumentResource r = new DocumentResource();
                            byte[] content = RedisStorage.this.decodeBinary(retObj.toString());
                            r.readStream = new ByteArrayReadStream(content);
                            r.length = content.length;
                            r.closeHandler = new Handler<Void>(){

                                public void handle(Void event) {
                                }
                            };
                            handler.handle((Object)r);
                        }
                    });
                }
            }
        });
    }

    private String encodePath(String path) {
        if (path.equals("/")) {
            path = "";
        }
        return path.replaceAll(":", "\u00a7").replaceAll("/", ":");
    }

    private String encodeBinary(byte[] bytes) {
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] decodeBinary(String s) {
        try {
            return s.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void notFound(Handler<Resource> handler) {
        Resource r = new Resource();
        r.exists = false;
        handler.handle((Object)r);
    }

    private void notModified(Handler<Resource> handler) {
        Resource r = new Resource();
        r.modified = false;
        handler.handle((Object)r);
    }

    @Override
    public void cleanup(Handler<DocumentResource> handler, String cleanupResourcesAmountStr) {
        long cleanupResourcesAmountUsed = this.cleanupResourcesAmount;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("RedisStorage cleanup resources,  cleanupResourcesAmount: " + cleanupResourcesAmountUsed));
        }
        try {
            cleanupResourcesAmountUsed = Long.parseLong(cleanupResourcesAmountStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanupRecursive(handler, 0L, cleanupResourcesAmountUsed, 200);
    }

    private boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    private class Delete
    implements RedisCommand {
        private JsonObject command;
        private Handler<Resource> handler;

        public Delete(JsonObject command, Handler<Resource> handler) {
            this.command = command;
            this.handler = handler;
        }

        @Override
        public void exec(final int executionCounter) {
            RedisStorage.this.eb.send(RedisStorage.this.redisAddress, this.command, (Handler)new Handler<Message<JsonObject>>(){

                public void handle(Message<JsonObject> event) {
                    String message;
                    String result = ((JsonObject)event.body()).getString("value");
                    if (RedisStorage.this.log.isTraceEnabled()) {
                        RedisStorage.this.log.trace((Object)("RedisStorage delete result: " + result));
                    }
                    if ("error".equals(((JsonObject)event.body()).getString("status")) && (message = ((JsonObject)event.body()).getString("message")) != null && message.startsWith("NOSCRIPT")) {
                        RedisStorage.this.log.warn((Object)"delete script couldn't be found, reload it");
                        RedisStorage.this.log.warn((Object)("amount the script got loaded: " + String.valueOf(executionCounter)));
                        if (executionCounter > 10) {
                            RedisStorage.this.log.error((Object)"amount the script got loaded is higher than 10, we abort");
                        } else {
                            ((LuaScriptState)RedisStorage.this.luaScripts.get((Object)LuaScript.DELETE)).loadLuaScript(new Delete(Delete.this.command, (Handler<Resource>)Delete.this.handler), executionCounter);
                        }
                        return;
                    }
                    if ("notFound".equals(result)) {
                        RedisStorage.this.notFound((Handler<Resource>)Delete.this.handler);
                        return;
                    }
                    Resource r = new Resource();
                    Delete.this.handler.handle((Object)r);
                }
            });
        }
    }

    private class Put
    implements RedisCommand {
        private DocumentResource d;
        private JsonObject command;
        private Handler<Resource> handler;

        public Put(DocumentResource d, JsonObject command, Handler<Resource> handler) {
            this.d = d;
            this.command = command;
            this.handler = handler;
        }

        @Override
        public void exec(final int executionCounter) {
            RedisStorage.this.eb.send(RedisStorage.this.redisAddress, this.command, (Handler)new Handler<Message<JsonObject>>(){

                public void handle(Message<JsonObject> event) {
                    String message;
                    if (RedisStorage.this.log.isTraceEnabled()) {
                        RedisStorage.this.log.trace((Object)("RedisStorage put result: " + ((JsonObject)event.body()).getString("status") + " " + ((JsonObject)event.body()).getString("value")));
                    }
                    if ("error".equals(((JsonObject)event.body()).getString("status")) && (message = ((JsonObject)event.body()).getString("message")) != null && message.startsWith("NOSCRIPT")) {
                        RedisStorage.this.log.warn((Object)"put script couldn't be found, reload it");
                        RedisStorage.this.log.warn((Object)("amount the script got loaded: " + String.valueOf(executionCounter)));
                        if (executionCounter > 10) {
                            RedisStorage.this.log.error((Object)"amount the script got loaded is higher than 10, we abort");
                        } else {
                            ((LuaScriptState)RedisStorage.this.luaScripts.get((Object)LuaScript.PUT)).loadLuaScript(new Put(Put.this.d, Put.this.command, (Handler<Resource>)Put.this.handler), executionCounter);
                        }
                        return;
                    }
                    if ("error".equals(((JsonObject)event.body()).getString("status")) && ((Put)Put.this).d.errorHandler != null) {
                        ((Put)Put.this).d.errorHandler.handle((Object)((JsonObject)event.body()).getString("message"));
                    } else if (((JsonObject)event.body()).getString("value") != null && ((JsonObject)event.body()).getString("value").startsWith("existingCollection")) {
                        CollectionResource c = new CollectionResource();
                        Put.this.handler.handle((Object)c);
                    } else if (((JsonObject)event.body()).getString("value") != null && ((JsonObject)event.body()).getString("value").startsWith("existingResource")) {
                        DocumentResource d = new DocumentResource();
                        d.exists = false;
                        Put.this.handler.handle((Object)d);
                    } else if ("notModified".equals(((JsonObject)event.body()).getString("value"))) {
                        RedisStorage.this.notModified((Handler<Resource>)Put.this.handler);
                    } else {
                        ((Put)Put.this).d.endHandler.handle(null);
                    }
                }
            });
        }
    }

    class ByteArrayWriteStream
    implements WriteStream<ByteArrayWriteStream> {
        private ByteArrayOutputStream bos = new ByteArrayOutputStream();

        ByteArrayWriteStream() {
        }

        public byte[] getBytes() {
            return this.bos.toByteArray();
        }

        public ByteArrayWriteStream write(Buffer data) {
            try {
                this.bos.write(data.getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public ByteArrayWriteStream setWriteQueueMaxSize(int maxSize) {
            return this;
        }

        public boolean writeQueueFull() {
            return false;
        }

        public ByteArrayWriteStream drainHandler(Handler<Void> handler) {
            return this;
        }

        public ByteArrayWriteStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }

    private class Get
    implements RedisCommand {
        private JsonObject command;
        private Handler<Resource> handler;

        public Get(JsonObject command, Handler<Resource> handler) {
            this.command = command;
            this.handler = handler;
        }

        @Override
        public void exec(final int executionCounter) {
            RedisStorage.this.eb.send(RedisStorage.this.redisAddress, this.command, (Handler)new Handler<Message<JsonObject>>(){

                public void handle(Message<JsonObject> event) {
                    String message;
                    Object value = ((JsonObject)event.body()).getField("value");
                    if (RedisStorage.this.log.isTraceEnabled()) {
                        RedisStorage.this.log.trace((Object)("RedisStorage get result: " + value));
                    }
                    if ("error".equals(((JsonObject)event.body()).getString("status")) && (message = ((JsonObject)event.body()).getString("message")) != null && message.startsWith("NOSCRIPT")) {
                        RedisStorage.this.log.warn((Object)"get script couldn't be found, reload it");
                        RedisStorage.this.log.warn((Object)("amount the script got loaded: " + String.valueOf(executionCounter)));
                        if (executionCounter > 10) {
                            RedisStorage.this.log.error((Object)"amount the script got loaded is higher than 10, we abort");
                        } else {
                            ((LuaScriptState)RedisStorage.this.luaScripts.get((Object)LuaScript.GET)).loadLuaScript(new Get(Get.this.command, (Handler<Resource>)Get.this.handler), executionCounter);
                        }
                        return;
                    }
                    if ("notModified".equals(value)) {
                        RedisStorage.this.notModified((Handler<Resource>)Get.this.handler);
                    } else if ("notFound".equals(value)) {
                        RedisStorage.this.notFound((Handler<Resource>)Get.this.handler);
                    } else if (value instanceof JsonArray) {
                        JsonArray values = (JsonArray)value;
                        RedisStorage.this.handleJsonArrayValues(values, (Handler<Resource>)Get.this.handler);
                    }
                }
            });
        }
    }

    public class ByteArrayReadStream
    implements ReadStream<ByteArrayReadStream> {
        ByteArrayInputStream content;
        int size;
        boolean paused;
        int position;
        Handler<Void> endHandler;
        Handler<Buffer> dataHandler;

        public ByteArrayReadStream(byte[] byteArray) {
            this.size = byteArray.length;
            this.content = new ByteArrayInputStream(byteArray);
        }

        private void doRead() {
            RedisStorage.this.vertx.runOnContext((Handler)new Handler<Void>(){

                public void handle(Void v) {
                    if (!ByteArrayReadStream.this.paused) {
                        if (ByteArrayReadStream.this.position < ByteArrayReadStream.this.size) {
                            int toRead = 8192;
                            if (ByteArrayReadStream.this.position + toRead > ByteArrayReadStream.this.size) {
                                toRead = ByteArrayReadStream.this.size - ByteArrayReadStream.this.position;
                            }
                            byte[] bytes = new byte[toRead];
                            ByteArrayReadStream.this.content.read(bytes, 0, toRead);
                            ByteArrayReadStream.this.dataHandler.handle((Object)new Buffer(bytes));
                            ByteArrayReadStream.this.position += toRead;
                            ByteArrayReadStream.this.doRead();
                        } else {
                            ByteArrayReadStream.this.endHandler.handle(null);
                        }
                    }
                }
            });
        }

        public ByteArrayReadStream resume() {
            this.paused = false;
            this.doRead();
            return this;
        }

        public ByteArrayReadStream pause() {
            this.paused = true;
            return this;
        }

        public ByteArrayReadStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        public ByteArrayReadStream endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }

        public ByteArrayReadStream dataHandler(Handler<Buffer> handler) {
            this.dataHandler = handler;
            this.doRead();
            return this;
        }
    }

    private class RedisCommandDoNothing
    implements RedisCommand {
        private RedisCommandDoNothing() {
        }

        @Override
        public void exec(int executionCounter) {
        }
    }

    private static interface RedisCommand {
        public void exec(int var1);
    }

    private class LuaScriptState {
        private LuaScript luaScriptType;
        private String script;
        private boolean logoutput = false;
        private String sha;

        private LuaScriptState(LuaScript luaScriptType, boolean logoutput) {
            this.luaScriptType = luaScriptType;
            this.logoutput = logoutput;
            this.composeLuaScript(luaScriptType);
            this.loadLuaScript(new RedisCommandDoNothing(), 0);
        }

        private void composeLuaScript(LuaScript luaScriptType) {
            RedisStorage.this.log.info((Object)("read the lua script for script type: " + (Object)((Object)luaScriptType) + " with logoutput: " + this.logoutput));
            if (LuaScript.CLEANUP.equals((Object)luaScriptType)) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("delscript", this.readLuaScriptFromClasspath(LuaScript.DELETE).replaceAll("return", "--return"));
                StrSubstitutor sub = new StrSubstitutor(values, "--%(", ")");
                this.script = sub.replace(this.readLuaScriptFromClasspath(LuaScript.CLEANUP));
            } else {
                this.script = this.readLuaScriptFromClasspath(luaScriptType);
            }
            this.sha = DigestUtils.sha1Hex((String)this.script);
        }

        private String readLuaScriptFromClasspath(LuaScript luaScriptType) {
            StringBuilder sb;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(luaScriptType.getFile())));
            try {
                String line;
                sb = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (!this.logoutput && line.contains("redis.log(redis.LOG_NOTICE,")) continue;
                    sb.append(line + "\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return sb.toString();
        }

        public void recomposeLuaScript() {
            this.composeLuaScript(this.luaScriptType);
        }

        public void loadLuaScript(final RedisCommand redisCommand, int executionCounter) {
            final int executionCounterIncr = ++executionCounter;
            JsonObject scriptExistsCommand = new JsonObject();
            scriptExistsCommand.putString("command", "script exists");
            JsonArray argsExistsCommand = new JsonArray();
            argsExistsCommand.add((Object)this.sha);
            scriptExistsCommand.putArray("args", argsExistsCommand);
            RedisStorage.this.eb.send(RedisStorage.this.redisAddress, scriptExistsCommand, (Handler)new Handler<Message<JsonObject>>(){

                public void handle(Message<JsonObject> event) {
                    Long exists = (Long)((JsonObject)event.body()).getArray("value").get(0);
                    if (Long.valueOf(1L).equals(exists)) {
                        RedisStorage.this.log.debug((Object)("RedisStorage script already exists in redis cache: " + (Object)((Object)LuaScriptState.this.luaScriptType)));
                        redisCommand.exec(executionCounterIncr);
                    } else {
                        RedisStorage.this.log.info((Object)("load lua script for script type: " + (Object)((Object)LuaScriptState.this.luaScriptType) + " logutput: " + LuaScriptState.this.logoutput));
                        JsonObject loadCommand = new JsonObject();
                        loadCommand.putString("command", "script load");
                        JsonArray args = new JsonArray();
                        args.add((Object)LuaScriptState.this.script);
                        loadCommand.putArray("args", args);
                        RedisStorage.this.eb.send(RedisStorage.this.redisAddress, loadCommand, (Handler)new Handler<Message<JsonObject>>(){

                            public void handle(Message<JsonObject> event) {
                                String newSha = ((JsonObject)event.body()).getString("value");
                                RedisStorage.this.log.info((Object)("got sha from redis for lua script: " + (Object)((Object)LuaScriptState.this.luaScriptType) + ": " + newSha));
                                if (!newSha.equals(LuaScriptState.this.sha)) {
                                    RedisStorage.this.log.warn((Object)("the sha calculated by myself: " + LuaScriptState.this.sha + " doesn't match with the sha from redis: " + newSha + ". We use the sha from redis"));
                                }
                                LuaScriptState.this.sha = newSha;
                                RedisStorage.this.log.info((Object)("execute redis command for script type: " + (Object)((Object)LuaScriptState.this.luaScriptType) + " with new sha: " + LuaScriptState.this.sha));
                                redisCommand.exec(executionCounterIncr);
                            }
                        });
                    }
                }
            });
        }

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public boolean getLogoutput() {
            return this.logoutput;
        }

        public void setLogoutput(boolean logoutput) {
            this.logoutput = logoutput;
        }

        public String getSha() {
            return this.sha;
        }

        public void setSha(String sha) {
            this.sha = sha;
        }
    }

    private static enum LuaScript {
        GET("get.lua"),
        PUT("put.lua"),
        DELETE("del.lua"),
        CLEANUP("cleanup.lua");

        private String file;

        private LuaScript(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }
}

