/*
 * Decompiled with CFR 0.152.
 */
package li.chee.vertx.reststorage;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import li.chee.vertx.reststorage.CollectionResource;
import li.chee.vertx.reststorage.DocumentResource;
import li.chee.vertx.reststorage.MimeTypeResolver;
import li.chee.vertx.reststorage.Resource;
import li.chee.vertx.reststorage.Storage;
import li.chee.vertx.reststorage.UrlParser;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.streams.Pump;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class RestStorageHandler
implements Handler<HttpServerRequest> {
    public static final String EXPIRE_AFTER_HEADER = "x-expire-after";
    public static final String ETAG_HEADER = "Etag";
    public static final String IF_NONE_MATCH_HEADER = "if-none-match";
    private static final String OFFSET_PARAMETER = "offset";
    private static final String LIMIT_PARAMETER = "limit";
    Logger log;
    RouteMatcher routeMatcher = new RouteMatcher();
    MimeTypeResolver mimeTypeResolver = new MimeTypeResolver("application/json; charset=utf-8");
    Map<String, String> editors = new LinkedHashMap<String, String>();
    String newMarker = "?new=true";

    public RestStorageHandler(final Logger log, final Storage storage, final String prefix, JsonObject editorConfig) {
        this.log = log;
        if (editorConfig != null) {
            for (Map.Entry entry : editorConfig.toMap().entrySet()) {
                this.editors.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        this.routeMatcher.postWithRegEx(".*_cleanup", (Handler)new Handler<HttpServerRequest>(){

            public void handle(final HttpServerRequest request) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"RestStorageHandler cleanup");
                }
                storage.cleanup(new Handler<DocumentResource>(){

                    public void handle(final DocumentResource documentResource) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"RestStorageHandler cleanup");
                        }
                        request.response().headers().add("Content-Length", "" + documentResource.length);
                        request.response().headers().add("Content-Type", "application/json; charset=utf-8");
                        request.response().setStatusCode(200);
                        Pump pump = Pump.createPump((ReadStream)documentResource.readStream, (WriteStream)request.response());
                        documentResource.readStream.endHandler((Handler)new Handler<Void>(){

                            public void handle(Void nothing) {
                                documentResource.closeHandler.handle(null);
                                request.response().end();
                            }
                        });
                        pump.start();
                    }
                }, request.params().get("cleanupResourcesAmount"));
            }
        });
        this.routeMatcher.getWithRegEx(prefix + ".*", (Handler)new Handler<HttpServerRequest>(){

            public void handle(final HttpServerRequest request) {
                final String path = RestStorageHandler.this.cleanPath(request.path().substring(prefix.length()));
                final String etag = request.headers().get(RestStorageHandler.IF_NONE_MATCH_HEADER);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("RestStorageHandler got GET Request path: " + path + " etag: " + etag));
                }
                String offsetFromUrl = request.params().get(RestStorageHandler.OFFSET_PARAMETER);
                String limitFromUrl = request.params().get(RestStorageHandler.LIMIT_PARAMETER);
                OffsetLimit offsetLimit = UrlParser.offsetLimit(offsetFromUrl, limitFromUrl);
                storage.get(path, etag, offsetLimit.offset, offsetLimit.limit, new Handler<Resource>(){

                    public void handle(Resource resource) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("RestStorageHandler resource exists: " + resource.exists));
                        }
                        if (!resource.modified) {
                            request.response().setStatusCode(304);
                            request.response().setStatusMessage("Not Modified");
                            request.response().headers().set(RestStorageHandler.ETAG_HEADER, etag);
                            request.response().headers().add("Content-Length", "0");
                            request.response().end();
                            return;
                        }
                        if (resource.exists) {
                            boolean html;
                            String accept = request.headers().get("Accept");
                            boolean bl = html = accept != null && accept.contains("text/html");
                            if (resource instanceof CollectionResource) {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("RestStorageHandler resource is collection: " + request.uri()));
                                }
                                CollectionResource collection = (CollectionResource)resource;
                                String collectionName = RestStorageHandler.this.collectionName(path);
                                if (html && !request.uri().endsWith("/")) {
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)"RestStorageHandler accept contains text/html and ends with /");
                                    }
                                    request.response().setStatusCode(302);
                                    request.response().setStatusMessage("Found");
                                    request.response().headers().add("Location", request.uri() + "/");
                                    request.response().end();
                                } else if (html) {
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)"RestStorageHandler accept contains text/html");
                                    }
                                    if ((request.query() == null || !request.query().contains("follow=off")) && collection.items.size() == 1 && collection.items.get(0) instanceof CollectionResource) {
                                        if (log.isTraceEnabled()) {
                                            log.trace((Object)"RestStorageHandler query contains follow=off");
                                        }
                                        request.response().setStatusCode(302);
                                        request.response().setStatusMessage("Found");
                                        request.response().headers().add("Location", request.uri() + collection.items.get((int)0).name);
                                        request.response().end();
                                        return;
                                    }
                                    StringBuilder body = new StringBuilder();
                                    String editor = null;
                                    if (RestStorageHandler.this.editors.size() > 0) {
                                        editor = RestStorageHandler.this.editors.values().iterator().next();
                                    }
                                    body.append("<!DOCTYPE html>\n");
                                    body.append("<html><head><meta charset='utf-8'/><title>" + collectionName + "</title>");
                                    body.append("<link href='//netdna.bootstrapcdn.com/twitter-bootstrap/2.3.1/css/bootstrap-combined.min.css' rel='stylesheet'></head>");
                                    body.append("<body><div style='font-size: 2em; height:48px; border-bottom: 1px solid lightgray; color: darkgray'><div style='padding:12px;'>" + RestStorageHandler.this.htmlPath(prefix + path) + "</div>");
                                    if (editor != null) {
                                        String editorString = editor.replace("$path", path + (path.equals("/") ? "" : "/") + "$new");
                                        editorString = editorString.replaceFirst("\\?", RestStorageHandler.this.newMarker);
                                        body.append("<div style='position: fixed; top: 8px; right: 20px;'><input id='name' type='text' placeholder='New Resource\u2026' onkeydown='if (event.keyCode == 13) { if(document.getElementById(\"name\").value) {window.location=\"" + editorString + "\".replace(\"$new\",document.getElementById(\"name\").value);}}'></input></div>");
                                    }
                                    body.append("</div><ul style='padding: 12px; font-size: 1.2em;' class='unstyled'><li><a href=\"../?follow=off\">..</a></li>");
                                    List<String> sortedNames = this.sortedNames(collection);
                                    for (String name : sortedNames) {
                                        body.append("<li><a href=\"" + name + "\">" + name + "</a>");
                                        body.append("</li>");
                                    }
                                    body.append("</ul></body></html>");
                                    request.response().headers().add("Content-Length", "" + body.length());
                                    request.response().headers().add("Content-Type", "text/html; charset=utf-8");
                                    request.response().end(body.toString());
                                } else {
                                    JsonArray array = new JsonArray();
                                    List<String> sortedNames = this.sortedNames(collection);
                                    for (String name : sortedNames) {
                                        array.addString(name);
                                    }
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)("RestStorageHandler return collection: " + sortedNames));
                                    }
                                    String body = new JsonObject().putArray(collectionName, array).encode();
                                    request.response().headers().add("Content-Length", "" + body.length());
                                    request.response().headers().add("Content-Type", "application/json; charset=utf-8");
                                    request.response().end(body);
                                }
                            }
                            if (resource instanceof DocumentResource) {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("RestStorageHandler resource is a DocumentResource: " + request.uri()));
                                }
                                if (request.uri().endsWith("/")) {
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)"RestStorageHandler DocumentResource ends with /");
                                    }
                                    request.response().setStatusCode(302);
                                    request.response().setStatusMessage("Found");
                                    request.response().headers().add("Location", request.uri().substring(0, request.uri().length() - 1));
                                    request.response().end();
                                } else {
                                    String editor;
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)"RestStorageHandler DocumentResource does not end with /");
                                    }
                                    String mimeType = RestStorageHandler.this.mimeTypeResolver.resolveMimeType(path);
                                    if (request.headers().names().contains("Accept") && request.headers().get("Accept").contains("text/html") && (editor = RestStorageHandler.this.editors.get(mimeType.split(";")[0])) != null) {
                                        request.response().setStatusCode(302);
                                        request.response().setStatusMessage("Found");
                                        String editorString = editor.replaceAll("\\$path", path);
                                        request.response().headers().add("Location", editorString);
                                        request.response().end();
                                        return;
                                    }
                                    final DocumentResource documentResource = (DocumentResource)resource;
                                    if (documentResource.etag != null && !documentResource.etag.isEmpty()) {
                                        request.response().headers().add(RestStorageHandler.ETAG_HEADER, documentResource.etag);
                                    }
                                    request.response().headers().add("Content-Length", "" + documentResource.length);
                                    request.response().headers().add("Content-Type", mimeType);
                                    Pump pump = Pump.createPump((ReadStream)documentResource.readStream, (WriteStream)request.response());
                                    documentResource.readStream.endHandler((Handler)new Handler<Void>(){

                                        public void handle(Void nothing) {
                                            documentResource.closeHandler.handle(null);
                                            request.response().end();
                                        }
                                    });
                                    pump.start();
                                }
                            }
                        } else {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("RestStorageHandler Could not find resource: " + request.uri()));
                            }
                            request.response().setStatusCode(404);
                            request.response().setStatusMessage("Not Found");
                            request.response().end("404 Not Found");
                        }
                    }

                    private List<String> sortedNames(CollectionResource collection) {
                        ArrayList<String> collections = new ArrayList<String>();
                        ArrayList<String> documents = new ArrayList<String>();
                        for (Resource r : collection.items) {
                            String name = r.name;
                            if (r instanceof CollectionResource) {
                                collections.add(name + "/");
                                continue;
                            }
                            documents.add(name);
                        }
                        collections.addAll(documents);
                        return collections;
                    }
                });
            }
        });
        this.routeMatcher.putWithRegEx(prefix + ".*", (Handler)new Handler<HttpServerRequest>(){

            public void handle(final HttpServerRequest request) {
                boolean merge;
                request.pause();
                String path = RestStorageHandler.this.cleanPath(request.path().substring(prefix.length()));
                long expire = -1L;
                if (request.headers().contains(RestStorageHandler.EXPIRE_AFTER_HEADER)) {
                    try {
                        expire = Long.parseLong(request.headers().get(RestStorageHandler.EXPIRE_AFTER_HEADER));
                    }
                    catch (NumberFormatException nfe) {
                        request.resume();
                        request.response().setStatusCode(400);
                        request.response().setStatusMessage("Invalid expire after parameter: " + request.headers().get(RestStorageHandler.EXPIRE_AFTER_HEADER));
                        request.response().end(request.response().getStatusMessage());
                        log.error((Object)("Expire after header, invalid value: " + request.response().getStatusMessage()));
                        return;
                    }
                }
                boolean bl = merge = request.query() != null && request.query().contains("merge=true") && RestStorageHandler.this.mimeTypeResolver.resolveMimeType(path).contains("application/json");
                if (log.isTraceEnabled()) {
                    log.trace((Object)("RestStorageHandler put resource: " + request.uri() + " with expire: " + expire));
                }
                final String etag = request.headers().get(RestStorageHandler.IF_NONE_MATCH_HEADER);
                storage.put(path, etag, merge, expire, new Handler<Resource>(){

                    public void handle(Resource resource) {
                        request.resume();
                        if (!resource.modified) {
                            request.response().setStatusCode(304);
                            request.response().setStatusMessage("Not Modified");
                            request.response().headers().set(RestStorageHandler.ETAG_HEADER, etag);
                            request.response().headers().add("Content-Length", "0");
                            request.response().end();
                            return;
                        }
                        if (!resource.exists && resource instanceof DocumentResource) {
                            request.response().setStatusCode(405);
                            request.response().setStatusMessage("Method Not Allowed");
                            request.response().headers().add("Allow", "GET, DELETE");
                            request.response().end();
                        }
                        if (resource instanceof CollectionResource) {
                            request.response().setStatusCode(405);
                            request.response().setStatusMessage("Method Not Allowed");
                            request.response().headers().add("Allow", "GET, DELETE");
                            request.response().end();
                        }
                        if (resource instanceof DocumentResource) {
                            final DocumentResource documentResource = (DocumentResource)resource;
                            documentResource.errorHandler = new Handler<String>(){

                                public void handle(String error) {
                                    request.response().setStatusCode(400);
                                    request.response().setStatusMessage("Bad Request");
                                    request.response().end(error);
                                }
                            };
                            documentResource.endHandler = new Handler<Void>(){

                                public void handle(Void event) {
                                    request.response().end();
                                }
                            };
                            Pump pump = Pump.createPump((ReadStream)request, (WriteStream)documentResource.writeStream);
                            request.endHandler((Handler)new Handler<Void>(){

                                public void handle(Void v) {
                                    documentResource.closeHandler.handle(null);
                                }
                            });
                            pump.start();
                        }
                    }
                });
            }
        });
        this.routeMatcher.deleteWithRegEx(prefix + ".*", (Handler)new Handler<HttpServerRequest>(){

            public void handle(final HttpServerRequest request) {
                String path = RestStorageHandler.this.cleanPath(request.path().substring(prefix.length()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("RestStorageHandler delete resource: " + request.uri()));
                }
                storage.delete(path, new Handler<Resource>(){

                    public void handle(Resource resource) {
                        if (!resource.exists) {
                            request.response().setStatusCode(404);
                            request.response().setStatusMessage("Not Found");
                            request.response().end("404 Not Found");
                        } else {
                            request.response().end();
                        }
                    }
                });
            }
        });
        this.routeMatcher.get(".*", (Handler)new Handler<HttpServerRequest>(){

            public void handle(HttpServerRequest request) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("RestStorageHandler resource not found: " + request.uri()));
                }
                request.response().setStatusCode(404);
                request.response().setStatusMessage("Not Found");
                request.response().end("404 Not Found");
            }
        });
        this.routeMatcher.all(".*", (Handler)new Handler<HttpServerRequest>(){

            public void handle(HttpServerRequest request) {
                request.response().setStatusCode(405);
                request.response().setStatusMessage("Method Not Allowed");
                request.response().end("405 Method Not Allowed");
            }
        });
    }

    public void handle(HttpServerRequest request) {
        this.routeMatcher.handle(request);
    }

    private String cleanPath(String value) {
        value = value.replaceAll("\\.\\.", "");
        while (value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.isEmpty()) {
            return "/";
        }
        return value;
    }

    private String collectionName(String path) {
        if (path.equals("/") || path.equals("")) {
            return "root";
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private String htmlPath(String path) {
        if (path.equals("/")) {
            return "/";
        }
        StringBuilder sb = new StringBuilder("");
        StringBuilder p = new StringBuilder();
        String[] parts = path.split("/");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            p.append(part);
            p.append("/");
            if (i < parts.length - 1) {
                sb.append(" <a href=\"");
                sb.append((CharSequence)p);
                sb.append("?follow=off\">");
                sb.append(part);
                sb.append("</a> > ");
                continue;
            }
            sb.append(" ");
            sb.append(part);
        }
        return sb.toString();
    }

    public static class OffsetLimit {
        public int offset;
        public int limit;

        public OffsetLimit(int offset, int limit) {
            this.offset = offset;
            this.limit = limit;
        }
    }
}

