/*
 * Decompiled with CFR 0.152.
 */
package li.chee.vertx.reststorage;

import li.chee.vertx.reststorage.EventBusAdapter;
import li.chee.vertx.reststorage.FileSystemStorage;
import li.chee.vertx.reststorage.RedisStorage;
import li.chee.vertx.reststorage.RestStorageHandler;
import li.chee.vertx.reststorage.Storage;
import org.vertx.java.core.Handler;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.platform.Verticle;

public class RestStorageMod
extends Verticle {
    public void start() {
        Storage storage;
        JsonObject config = this.container.config();
        Logger log = this.container.logger();
        String storageName = config.getString("storage", "filesystem");
        int port = config.getNumber("port", 8989).intValue();
        String prefix = config.getString("prefix", "");
        String storageAddress = config.getString("storageAddress", "resource-storage");
        JsonObject editorConfig = config.getObject("editors");
        prefix = prefix.equals("/") ? "" : prefix;
        switch (storageName) {
            case "filesystem": {
                String root = config.getString("root", ".");
                storage = new FileSystemStorage(this.vertx, root);
                break;
            }
            case "redis": {
                if (config.getObject("redisConfig") != null) {
                    this.container.deployModule("io.vertx~mod-redis~1.1.3", config.getObject("redisConfig"));
                }
                String redisAddress = config.getString("redisAddress", "redis-client");
                String redisResourcesPrefix = config.getString("resourcesPrefix", "rest-storage:resources");
                String redisCollectionsPrefix = config.getString("collectionsPrefix", "rest-storage:collections");
                String redisDeltaResourcesPrefix = config.getString("deltaResourcesPrefix", "delta:resources");
                String redisDeltaEtagsPrefix = config.getString("deltaEtagsPrefix", "delta:etags");
                String expirableSet = config.getString("expirablePrefix", "rest-storage:expirable");
                Long cleanupResourcesAmount = config.getLong("resourceCleanupAmount", 100000L);
                storage = new RedisStorage(this.vertx, log, redisAddress, redisResourcesPrefix, redisCollectionsPrefix, redisDeltaResourcesPrefix, redisDeltaEtagsPrefix, expirableSet, cleanupResourcesAmount);
                break;
            }
            default: {
                throw new RuntimeException("Storage not supported: " + storageName);
            }
        }
        RestStorageHandler handler = new RestStorageHandler(log, storage, prefix, editorConfig);
        this.vertx.createHttpServer().requestHandler((Handler)handler).listen(port);
        new EventBusAdapter().init(this.vertx, storageAddress, handler);
    }
}

