/*
 * Decompiled with CFR 0.152.
 */
package li.naska.spring.ejb;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PreDestroy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class AbstractSpringSingletonBean {
    private final Map<String, ConfigurableApplicationContext> applicationContextReferences = new WeakHashMap<String, ConfigurableApplicationContext>();

    public synchronized ApplicationContext getApplicationContext(String key, Class<?> ... annotedClasses) {
        if (!this.applicationContextReferences.containsKey(key)) {
            this.applicationContextReferences.put(key, (ConfigurableApplicationContext)new AnnotationConfigApplicationContext((Class[])annotedClasses));
        }
        return (ApplicationContext)this.applicationContextReferences.get(key);
    }

    @PreDestroy
    void doReleaseBean() {
        Iterator<Map.Entry<String, ConfigurableApplicationContext>> iterator = this.applicationContextReferences.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().close();
            iterator.remove();
        }
    }
}

