/*
 * Decompiled with CFR 0.152.
 */
package li.naska.spring.ejb.interceptor;

import javax.annotation.PostConstruct;
import javax.ejb.EJBException;
import javax.ejb.PostActivate;
import javax.interceptor.InvocationContext;
import li.naska.spring.ejb.AbstractSpringSingletonBean;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSpringAutowiringInterceptor {
    @PostConstruct
    @PostActivate
    public void autowireBean(InvocationContext invocationContext) {
        this.doAutowireBean(invocationContext.getTarget());
        try {
            invocationContext.proceed();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    protected void doAutowireBean(Object target) {
        AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
        this.configureBeanPostProcessor(bpp, target);
        bpp.setBeanFactory(this.getBeanFactory());
        bpp.processInjection(target);
    }

    protected void configureBeanPostProcessor(AutowiredAnnotationBeanPostProcessor processor, Object target) {
    }

    protected String getKey() {
        return this.getClass().getName();
    }

    protected BeanFactory getBeanFactory() {
        return this.getApplicationContext(this.getKey()).getAutowireCapableBeanFactory();
    }

    protected ApplicationContext getApplicationContext(String key) {
        return this.getSpringSingletonBean().getApplicationContext(key, this.getAnnotatedClasses());
    }

    protected abstract AbstractSpringSingletonBean getSpringSingletonBean();

    protected abstract Class<?>[] getAnnotatedClasses();
}

